package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRole;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleBuilder;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSDNSZoneSpecFluent<A extends AWSDNSZoneSpecFluent<A>> extends BaseFluent<A>{
  public AWSDNSZoneSpecFluent() {
  }
  
  public AWSDNSZoneSpecFluent(AWSDNSZoneSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AWSResourceTagBuilder> additionalTags = new ArrayList<AWSResourceTagBuilder>();
  private AssumeRoleBuilder credentialsAssumeRole;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String region;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSDNSZoneSpec instance) {
    instance = (instance != null ? instance : new AWSDNSZoneSpec());
  
    if (instance != null) {
        this.withAdditionalTags(instance.getAdditionalTags());
        this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withRegion(instance.getRegion());
        this.withAdditionalTags(instance.getAdditionalTags());
        this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withRegion(instance.getRegion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToAdditionalTags(int index,AWSResourceTag item) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= additionalTags.size()) { _visitables.get("additionalTags").add(builder); additionalTags.add(builder); } else { _visitables.get("additionalTags").add(index, builder); additionalTags.add(index, builder);}
    return (A)this;
  }
  
  public A setToAdditionalTags(int index,AWSResourceTag item) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= additionalTags.size()) { _visitables.get("additionalTags").add(builder); additionalTags.add(builder); } else { _visitables.get("additionalTags").set(index, builder); additionalTags.set(index, builder);}
    return (A)this;
  }
  
  public A addToAdditionalTags(io.fabric8.openshift.api.model.hive.v1.AWSResourceTag... items) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").add(builder);this.additionalTags.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalTags(Collection<AWSResourceTag> items) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").add(builder);this.additionalTags.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalTags(io.fabric8.openshift.api.model.hive.v1.AWSResourceTag... items) {
    if (this.additionalTags == null) return (A)this;
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").remove(builder); this.additionalTags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalTags(Collection<AWSResourceTag> items) {
    if (this.additionalTags == null) return (A)this;
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").remove(builder); this.additionalTags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalTags(Predicate<AWSResourceTagBuilder> predicate) {
    if (additionalTags == null) return (A) this;
    final Iterator<AWSResourceTagBuilder> each = additionalTags.iterator();
    final List visitables = _visitables.get("additionalTags");
    while (each.hasNext()) {
      AWSResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AWSResourceTag> buildAdditionalTags() {
    return additionalTags != null ? build(additionalTags) : null;
  }
  
  public AWSResourceTag buildAdditionalTag(int index) {
    return this.additionalTags.get(index).build();
  }
  
  public AWSResourceTag buildFirstAdditionalTag() {
    return this.additionalTags.get(0).build();
  }
  
  public AWSResourceTag buildLastAdditionalTag() {
    return this.additionalTags.get(additionalTags.size() - 1).build();
  }
  
  public AWSResourceTag buildMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
    for (AWSResourceTagBuilder item: additionalTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
    for (AWSResourceTagBuilder item: additionalTags) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withAdditionalTags(List<AWSResourceTag> additionalTags) {
    if (this.additionalTags != null) { _visitables.get("additionalTags").clear();}
    if (additionalTags != null) {this.additionalTags = new ArrayList(); for (AWSResourceTag item : additionalTags){this.addToAdditionalTags(item);}} else { this.additionalTags = null;} return (A) this;
  }
  
  public A withAdditionalTags(io.fabric8.openshift.api.model.hive.v1.AWSResourceTag... additionalTags) {
    if (this.additionalTags != null) {this.additionalTags.clear(); _visitables.remove("additionalTags"); }
    if (additionalTags != null) {for (AWSResourceTag item :additionalTags){ this.addToAdditionalTags(item);}} return (A) this;
  }
  
  public boolean hasAdditionalTags() {
    return additionalTags != null && !additionalTags.isEmpty();
  }
  
  public A addNewAdditionalTag(String key,String value) {
    return (A)addToAdditionalTags(new AWSResourceTag(key, value));
  }
  
  public AdditionalTagsNested<A> addNewAdditionalTag() {
    return new AdditionalTagsNested(-1, null);
  }
  
  public AdditionalTagsNested<A> addNewAdditionalTagLike(AWSResourceTag item) {
    return new AdditionalTagsNested(-1, item);
  }
  
  public AdditionalTagsNested<A> setNewAdditionalTagLike(int index,AWSResourceTag item) {
    return new AdditionalTagsNested(index, item);
  }
  
  public AdditionalTagsNested<A> editAdditionalTag(int index) {
    if (additionalTags.size() <= index) throw new RuntimeException("Can't edit additionalTags. Index exceeds size.");
    return setNewAdditionalTagLike(index, buildAdditionalTag(index));
  }
  
  public AdditionalTagsNested<A> editFirstAdditionalTag() {
    if (additionalTags.size() == 0) throw new RuntimeException("Can't edit first additionalTags. The list is empty.");
    return setNewAdditionalTagLike(0, buildAdditionalTag(0));
  }
  
  public AdditionalTagsNested<A> editLastAdditionalTag() {
    int index = additionalTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalTags. The list is empty.");
    return setNewAdditionalTagLike(index, buildAdditionalTag(index));
  }
  
  public AdditionalTagsNested<A> editMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalTags.size();i++) { 
    if (predicate.test(additionalTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalTags. No match found.");
    return setNewAdditionalTagLike(index, buildAdditionalTag(index));
  }
  
  public AssumeRole buildCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  
  public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
    _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole);
    if (credentialsAssumeRole!=null){ this.credentialsAssumeRole= new AssumeRoleBuilder(credentialsAssumeRole); _visitables.get("credentialsAssumeRole").add(this.credentialsAssumeRole);} else { this.credentialsAssumeRole = null; _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole); } return (A) this;
  }
  
  public boolean hasCredentialsAssumeRole() {
    return this.credentialsAssumeRole != null;
  }
  
  public A withNewCredentialsAssumeRole(String externalID,String roleARN) {
    return (A)withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
  }
  
  public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
    return new CredentialsAssumeRoleNested(null);
  }
  
  public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
    return new CredentialsAssumeRoleNested(item);
  }
  
  public CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(java.util.Optional.ofNullable(buildCredentialsAssumeRole()).orElse(null));
  }
  
  public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(java.util.Optional.ofNullable(buildCredentialsAssumeRole()).orElse(new AssumeRoleBuilder().build()));
  }
  
  public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
    return withNewCredentialsAssumeRoleLike(java.util.Optional.ofNullable(buildCredentialsAssumeRole()).orElse(item));
  }
  
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  
  public boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new CredentialsSecretRefNested(null);
  }
  
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new CredentialsSecretRefNested(item);
  }
  
  public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(null));
  }
  
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(item));
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSDNSZoneSpecFluent that = (AWSDNSZoneSpecFluent) o;
    if (!java.util.Objects.equals(additionalTags, that.additionalTags)) return false;
  
    if (!java.util.Objects.equals(credentialsAssumeRole, that.credentialsAssumeRole)) return false;
  
    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;
  
    if (!java.util.Objects.equals(region, that.region)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalTags,  credentialsAssumeRole,  credentialsSecretRef,  region,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTags != null && !additionalTags.isEmpty()) { sb.append("additionalTags:"); sb.append(additionalTags + ","); }
    if (credentialsAssumeRole != null) { sb.append("credentialsAssumeRole:"); sb.append(credentialsAssumeRole + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AdditionalTagsNested<N> extends AWSResourceTagFluent<AdditionalTagsNested<N>> implements Nested<N>{
    AdditionalTagsNested(int index,AWSResourceTag item) {
      this.index = index;
      this.builder = new AWSResourceTagBuilder(this, item);
    }
    AWSResourceTagBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSDNSZoneSpecFluent.this.setToAdditionalTags(index,builder.build());
    }
    
    public N endAdditionalTag() {
      return and();
    }
    
  
  }
  public class CredentialsAssumeRoleNested<N> extends AssumeRoleFluent<CredentialsAssumeRoleNested<N>> implements Nested<N>{
    CredentialsAssumeRoleNested(AssumeRole item) {
      this.builder = new AssumeRoleBuilder(this, item);
    }
    AssumeRoleBuilder builder;
    
    public N and() {
      return (N) AWSDNSZoneSpecFluent.this.withCredentialsAssumeRole(builder.build());
    }
    
    public N endCredentialsAssumeRole() {
      return and();
    }
    
  
  }
  public class CredentialsSecretRefNested<N> extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>> implements Nested<N>{
    CredentialsSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) AWSDNSZoneSpecFluent.this.withCredentialsSecretRef(builder.build());
    }
    
    public N endCredentialsSecretRef() {
      return and();
    }
    
  
  }

}