package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterClaimSpecFluent<A extends ClusterClaimSpecFluent<A>> extends BaseFluent<A>{
  public ClusterClaimSpecFluent() {
  }
  
  public ClusterClaimSpecFluent(ClusterClaimSpec instance) {
    this.copyInstance(instance);
  }
  private String clusterPoolName;
  private Duration lifetime;
  private String namespace;
  private List<Subject> subjects = new ArrayList<Subject>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterClaimSpec instance) {
    instance = (instance != null ? instance : new ClusterClaimSpec());
  
    if (instance != null) {
        this.withClusterPoolName(instance.getClusterPoolName());
        this.withLifetime(instance.getLifetime());
        this.withNamespace(instance.getNamespace());
        this.withSubjects(instance.getSubjects());
        this.withClusterPoolName(instance.getClusterPoolName());
        this.withLifetime(instance.getLifetime());
        this.withNamespace(instance.getNamespace());
        this.withSubjects(instance.getSubjects());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getClusterPoolName() {
    return this.clusterPoolName;
  }
  
  public A withClusterPoolName(String clusterPoolName) {
    this.clusterPoolName=clusterPoolName; return (A) this;
  }
  
  public boolean hasClusterPoolName() {
    return this.clusterPoolName != null;
  }
  
  public Duration getLifetime() {
    return this.lifetime;
  }
  
  public A withLifetime(Duration lifetime) {
    this.lifetime=lifetime; return (A) this;
  }
  
  public boolean hasLifetime() {
    return this.lifetime != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public A addToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<Subject>();}
    this.subjects.add(index, item);
    return (A)this;
  }
  
  public A setToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<Subject>();}
    this.subjects.set(index, item); return (A)this;
  }
  
  public A addToSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<Subject>();}
    for (Subject item : items) {this.subjects.add(item);} return (A)this;
  }
  
  public A addAllToSubjects(Collection<Subject> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<Subject>();}
    for (Subject item : items) {this.subjects.add(item);} return (A)this;
  }
  
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    if (this.subjects == null) return (A)this;
    for (Subject item : items) { this.subjects.remove(item);} return (A)this;
  }
  
  public A removeAllFromSubjects(Collection<Subject> items) {
    if (this.subjects == null) return (A)this;
    for (Subject item : items) { this.subjects.remove(item);} return (A)this;
  }
  
  public List<Subject> getSubjects() {
    return this.subjects;
  }
  
  public Subject getSubject(int index) {
    return this.subjects.get(index);
  }
  
  public Subject getFirstSubject() {
    return this.subjects.get(0);
  }
  
  public Subject getLastSubject() {
    return this.subjects.get(subjects.size() - 1);
  }
  
  public Subject getMatchingSubject(Predicate<Subject> predicate) {
    for (Subject item: subjects) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingSubject(Predicate<Subject> predicate) {
    for (Subject item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSubjects(List<Subject> subjects) {
    if (subjects != null) {this.subjects = new ArrayList(); for (Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  
  public A withSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear(); _visitables.remove("subjects"); }
    if (subjects != null) {for (Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  
  public boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  
  public A addNewSubject(String apiGroup,String kind,String name,String namespace) {
    return (A)addToSubjects(new Subject(apiGroup, kind, name, namespace));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterClaimSpecFluent that = (ClusterClaimSpecFluent) o;
    if (!java.util.Objects.equals(clusterPoolName, that.clusterPoolName)) return false;
  
    if (!java.util.Objects.equals(lifetime, that.lifetime)) return false;
  
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
  
    if (!java.util.Objects.equals(subjects, that.subjects)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterPoolName,  lifetime,  namespace,  subjects,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterPoolName != null) { sb.append("clusterPoolName:"); sb.append(clusterPoolName + ","); }
    if (lifetime != null) { sb.append("lifetime:"); sb.append(lifetime + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (subjects != null && !subjects.isEmpty()) { sb.append("subjects:"); sb.append(subjects + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}