package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterMetadataFluent<A extends ClusterMetadataFluent<A>> extends BaseFluent<A>{
  public ClusterMetadataFluent() {
  }
  
  public ClusterMetadataFluent(ClusterMetadata instance) {
    this.copyInstance(instance);
  }
  private LocalObjectReferenceBuilder adminKubeconfigSecretRef;
  private LocalObjectReferenceBuilder adminPasswordSecretRef;
  private String clusterID;
  private String infraID;
  private ClusterPlatformMetadataBuilder platform;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterMetadata instance) {
    instance = (instance != null ? instance : new ClusterMetadata());
  
    if (instance != null) {
        this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
        this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
        this.withClusterID(instance.getClusterID());
        this.withInfraID(instance.getInfraID());
        this.withPlatform(instance.getPlatform());
        this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
        this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
        this.withClusterID(instance.getClusterID());
        this.withInfraID(instance.getInfraID());
        this.withPlatform(instance.getPlatform());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public LocalObjectReference buildAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef!=null ?this.adminKubeconfigSecretRef.build():null;
  }
  
  public A withAdminKubeconfigSecretRef(LocalObjectReference adminKubeconfigSecretRef) {
    _visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef);
    if (adminKubeconfigSecretRef!=null){ this.adminKubeconfigSecretRef= new LocalObjectReferenceBuilder(adminKubeconfigSecretRef); _visitables.get("adminKubeconfigSecretRef").add(this.adminKubeconfigSecretRef);} else { this.adminKubeconfigSecretRef = null; _visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef); } return (A) this;
  }
  
  public boolean hasAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef != null;
  }
  
  public A withNewAdminKubeconfigSecretRef(String name) {
    return (A)withAdminKubeconfigSecretRef(new LocalObjectReference(name));
  }
  
  public AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRef() {
    return new AdminKubeconfigSecretRefNested(null);
  }
  
  public AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return new AdminKubeconfigSecretRefNested(item);
  }
  
  public AdminKubeconfigSecretRefNested<A> editAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildAdminKubeconfigSecretRef()).orElse(null));
  }
  
  public AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildAdminKubeconfigSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return withNewAdminKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildAdminKubeconfigSecretRef()).orElse(item));
  }
  
  public LocalObjectReference buildAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef!=null ?this.adminPasswordSecretRef.build():null;
  }
  
  public A withAdminPasswordSecretRef(LocalObjectReference adminPasswordSecretRef) {
    _visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef);
    if (adminPasswordSecretRef!=null){ this.adminPasswordSecretRef= new LocalObjectReferenceBuilder(adminPasswordSecretRef); _visitables.get("adminPasswordSecretRef").add(this.adminPasswordSecretRef);} else { this.adminPasswordSecretRef = null; _visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef); } return (A) this;
  }
  
  public boolean hasAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef != null;
  }
  
  public A withNewAdminPasswordSecretRef(String name) {
    return (A)withAdminPasswordSecretRef(new LocalObjectReference(name));
  }
  
  public AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRef() {
    return new AdminPasswordSecretRefNested(null);
  }
  
  public AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return new AdminPasswordSecretRefNested(item);
  }
  
  public AdminPasswordSecretRefNested<A> editAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(java.util.Optional.ofNullable(buildAdminPasswordSecretRef()).orElse(null));
  }
  
  public AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(java.util.Optional.ofNullable(buildAdminPasswordSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return withNewAdminPasswordSecretRefLike(java.util.Optional.ofNullable(buildAdminPasswordSecretRef()).orElse(item));
  }
  
  public String getClusterID() {
    return this.clusterID;
  }
  
  public A withClusterID(String clusterID) {
    this.clusterID=clusterID; return (A) this;
  }
  
  public boolean hasClusterID() {
    return this.clusterID != null;
  }
  
  public String getInfraID() {
    return this.infraID;
  }
  
  public A withInfraID(String infraID) {
    this.infraID=infraID; return (A) this;
  }
  
  public boolean hasInfraID() {
    return this.infraID != null;
  }
  
  public ClusterPlatformMetadata buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  
  public A withPlatform(ClusterPlatformMetadata platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new ClusterPlatformMetadataBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(ClusterPlatformMetadata item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new ClusterPlatformMetadataBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(ClusterPlatformMetadata item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterMetadataFluent that = (ClusterMetadataFluent) o;
    if (!java.util.Objects.equals(adminKubeconfigSecretRef, that.adminKubeconfigSecretRef)) return false;
  
    if (!java.util.Objects.equals(adminPasswordSecretRef, that.adminPasswordSecretRef)) return false;
  
    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;
  
    if (!java.util.Objects.equals(infraID, that.infraID)) return false;
  
    if (!java.util.Objects.equals(platform, that.platform)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(adminKubeconfigSecretRef,  adminPasswordSecretRef,  clusterID,  infraID,  platform,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (adminKubeconfigSecretRef != null) { sb.append("adminKubeconfigSecretRef:"); sb.append(adminKubeconfigSecretRef + ","); }
    if (adminPasswordSecretRef != null) { sb.append("adminPasswordSecretRef:"); sb.append(adminPasswordSecretRef + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (infraID != null) { sb.append("infraID:"); sb.append(infraID + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AdminKubeconfigSecretRefNested<N> extends LocalObjectReferenceFluent<AdminKubeconfigSecretRefNested<N>> implements Nested<N>{
    AdminKubeconfigSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withAdminKubeconfigSecretRef(builder.build());
    }
    
    public N endAdminKubeconfigSecretRef() {
      return and();
    }
    
  
  }
  public class AdminPasswordSecretRefNested<N> extends LocalObjectReferenceFluent<AdminPasswordSecretRefNested<N>> implements Nested<N>{
    AdminPasswordSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withAdminPasswordSecretRef(builder.build());
    }
    
    public N endAdminPasswordSecretRef() {
      return and();
    }
    
  
  }
  public class PlatformNested<N> extends ClusterPlatformMetadataFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(ClusterPlatformMetadata item) {
      this.builder = new ClusterPlatformMetadataBuilder(this, item);
    }
    ClusterPlatformMetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }

}