package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.openshift.api.model.hive.aws.v1.AwsMetadataBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.AwsMetadataFluent;
import java.lang.SuppressWarnings;
import io.fabric8.openshift.api.model.hive.azure.v1.AzureMetadataFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.openshift.api.model.hive.azure.v1.AzureMetadataBuilder;
import java.util.LinkedHashMap;
import io.fabric8.openshift.api.model.hive.azure.v1.AzureMetadata;
import io.fabric8.openshift.api.model.hive.aws.v1.AwsMetadata;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterPlatformMetadataFluent<A extends ClusterPlatformMetadataFluent<A>> extends BaseFluent<A>{
  public ClusterPlatformMetadataFluent() {
  }
  
  public ClusterPlatformMetadataFluent(ClusterPlatformMetadata instance) {
    this.copyInstance(instance);
  }
  private AwsMetadataBuilder aws;
  private AzureMetadataBuilder azure;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterPlatformMetadata instance) {
    instance = (instance != null ? instance : new ClusterPlatformMetadata());
  
    if (instance != null) {
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public AwsMetadata buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  
  public A withAws(AwsMetadata aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AwsMetadataBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public A withNewAws(String hostedZoneRole) {
    return (A)withAws(new AwsMetadata(hostedZoneRole));
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(AwsMetadata item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AwsMetadataBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(AwsMetadata item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public AzureMetadata buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  
  public A withAzure(AzureMetadata azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzureMetadataBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public A withNewAzure(String resourceGroupName) {
    return (A)withAzure(new AzureMetadata(resourceGroupName));
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(AzureMetadata item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new AzureMetadataBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(AzureMetadata item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterPlatformMetadataFluent that = (ClusterPlatformMetadataFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
  
    if (!java.util.Objects.equals(azure, that.azure)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends AwsMetadataFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AwsMetadata item) {
      this.builder = new AwsMetadataBuilder(this, item);
    }
    AwsMetadataBuilder builder;
    
    public N and() {
      return (N) ClusterPlatformMetadataFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends AzureMetadataFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(AzureMetadata item) {
      this.builder = new AzureMetadataBuilder(this, item);
    }
    AzureMetadataBuilder builder;
    
    public N and() {
      return (N) ClusterPlatformMetadataFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }

}