package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.openshift.api.model.hive.agent.v1.BareMetalPlatformBuilder;
import io.fabric8.openshift.api.model.hive.agent.v1.BareMetalPlatformFluent;
import io.fabric8.openshift.api.model.hive.azure.v1.AzurePlatformBuilder;
import io.fabric8.openshift.api.model.hive.alibabacloud.v1.Platform;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.openshift.api.model.hive.aws.v1.AwsPlatformBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.hive.agent.v1.BareMetalPlatform;
import io.fabric8.openshift.api.model.hive.alibabacloud.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.hive.azure.v1.AzurePlatformFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.AwsPlatformFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.AwsPlatform;
import java.lang.Object;
import io.fabric8.openshift.api.model.hive.azure.v1.AzurePlatform;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformFluent<A extends io.fabric8.openshift.api.model.hive.v1.PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  
  public PlatformFluent(io.fabric8.openshift.api.model.hive.v1.Platform instance) {
    this.copyInstance(instance);
  }
  private BareMetalPlatformBuilder agentBareMetal;
  private PlatformBuilder alibabacloud;
  private AwsPlatformBuilder aws;
  private AzurePlatformBuilder azure;
  private io.fabric8.openshift.api.model.hive.baremetal.v1.PlatformBuilder baremetal;
  private io.fabric8.openshift.api.model.hive.gcp.v1.PlatformBuilder gcp;
  private io.fabric8.openshift.api.model.hive.ibmcloud.v1.PlatformBuilder ibmcloud;
  private io.fabric8.openshift.api.model.hive.none.v1.PlatformBuilder none;
  private io.fabric8.openshift.api.model.hive.openstack.v1.PlatformBuilder openstack;
  private io.fabric8.openshift.api.model.hive.ovirt.v1.PlatformBuilder ovirt;
  private io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder vsphere;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(io.fabric8.openshift.api.model.hive.v1.Platform instance) {
    instance = (instance != null ? instance : new io.fabric8.openshift.api.model.hive.v1.Platform());
  
    if (instance != null) {
        this.withAgentBareMetal(instance.getAgentBareMetal());
        this.withAlibabacloud(instance.getAlibabacloud());
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withBaremetal(instance.getBaremetal());
        this.withGcp(instance.getGcp());
        this.withIbmcloud(instance.getIbmcloud());
        this.withNone(instance.getNone());
        this.withOpenstack(instance.getOpenstack());
        this.withOvirt(instance.getOvirt());
        this.withVsphere(instance.getVsphere());
        this.withAgentBareMetal(instance.getAgentBareMetal());
        this.withAlibabacloud(instance.getAlibabacloud());
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withBaremetal(instance.getBaremetal());
        this.withGcp(instance.getGcp());
        this.withIbmcloud(instance.getIbmcloud());
        this.withNone(instance.getNone());
        this.withOpenstack(instance.getOpenstack());
        this.withOvirt(instance.getOvirt());
        this.withVsphere(instance.getVsphere());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public BareMetalPlatform buildAgentBareMetal() {
    return this.agentBareMetal!=null ?this.agentBareMetal.build():null;
  }
  
  public A withAgentBareMetal(BareMetalPlatform agentBareMetal) {
    _visitables.get("agentBareMetal").remove(this.agentBareMetal);
    if (agentBareMetal!=null){ this.agentBareMetal= new BareMetalPlatformBuilder(agentBareMetal); _visitables.get("agentBareMetal").add(this.agentBareMetal);} else { this.agentBareMetal = null; _visitables.get("agentBareMetal").remove(this.agentBareMetal); } return (A) this;
  }
  
  public boolean hasAgentBareMetal() {
    return this.agentBareMetal != null;
  }
  
  public AgentBareMetalNested<A> withNewAgentBareMetal() {
    return new AgentBareMetalNested(null);
  }
  
  public AgentBareMetalNested<A> withNewAgentBareMetalLike(BareMetalPlatform item) {
    return new AgentBareMetalNested(item);
  }
  
  public AgentBareMetalNested<A> editAgentBareMetal() {
    return withNewAgentBareMetalLike(java.util.Optional.ofNullable(buildAgentBareMetal()).orElse(null));
  }
  
  public AgentBareMetalNested<A> editOrNewAgentBareMetal() {
    return withNewAgentBareMetalLike(java.util.Optional.ofNullable(buildAgentBareMetal()).orElse(new BareMetalPlatformBuilder().build()));
  }
  
  public AgentBareMetalNested<A> editOrNewAgentBareMetalLike(BareMetalPlatform item) {
    return withNewAgentBareMetalLike(java.util.Optional.ofNullable(buildAgentBareMetal()).orElse(item));
  }
  
  public Platform buildAlibabacloud() {
    return this.alibabacloud!=null ?this.alibabacloud.build():null;
  }
  
  public A withAlibabacloud(Platform alibabacloud) {
    _visitables.get("alibabacloud").remove(this.alibabacloud);
    if (alibabacloud!=null){ this.alibabacloud= new PlatformBuilder(alibabacloud); _visitables.get("alibabacloud").add(this.alibabacloud);} else { this.alibabacloud = null; _visitables.get("alibabacloud").remove(this.alibabacloud); } return (A) this;
  }
  
  public boolean hasAlibabacloud() {
    return this.alibabacloud != null;
  }
  
  public AlibabacloudNested<A> withNewAlibabacloud() {
    return new AlibabacloudNested(null);
  }
  
  public AlibabacloudNested<A> withNewAlibabacloudLike(Platform item) {
    return new AlibabacloudNested(item);
  }
  
  public AlibabacloudNested<A> editAlibabacloud() {
    return withNewAlibabacloudLike(java.util.Optional.ofNullable(buildAlibabacloud()).orElse(null));
  }
  
  public AlibabacloudNested<A> editOrNewAlibabacloud() {
    return withNewAlibabacloudLike(java.util.Optional.ofNullable(buildAlibabacloud()).orElse(new PlatformBuilder().build()));
  }
  
  public AlibabacloudNested<A> editOrNewAlibabacloudLike(Platform item) {
    return withNewAlibabacloudLike(java.util.Optional.ofNullable(buildAlibabacloud()).orElse(item));
  }
  
  public AwsPlatform buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  
  public A withAws(AwsPlatform aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AwsPlatformBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(AwsPlatform item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AwsPlatformBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(AwsPlatform item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public AzurePlatform buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  
  public A withAzure(AzurePlatform azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzurePlatformBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(AzurePlatform item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new AzurePlatformBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(AzurePlatform item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.baremetal.v1.Platform buildBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  
  public A withBaremetal(io.fabric8.openshift.api.model.hive.baremetal.v1.Platform baremetal) {
    _visitables.get("baremetal").remove(this.baremetal);
    if (baremetal!=null){ this.baremetal= new io.fabric8.openshift.api.model.hive.baremetal.v1.PlatformBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} else { this.baremetal = null; _visitables.get("baremetal").remove(this.baremetal); } return (A) this;
  }
  
  public boolean hasBaremetal() {
    return this.baremetal != null;
  }
  
  public BaremetalBaremetalNested<A> withNewBaremetalBaremetal() {
    return new BaremetalBaremetalNested(null);
  }
  
  public BaremetalBaremetalNested<A> withNewBaremetalLike(io.fabric8.openshift.api.model.hive.baremetal.v1.Platform item) {
    return new BaremetalBaremetalNested(item);
  }
  
  public BaremetalBaremetalNested<A> editBaremetalBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(null));
  }
  
  public BaremetalBaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(new io.fabric8.openshift.api.model.hive.baremetal.v1.PlatformBuilder().build()));
  }
  
  public BaremetalBaremetalNested<A> editOrNewBaremetalLike(io.fabric8.openshift.api.model.hive.baremetal.v1.Platform item) {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.gcp.v1.Platform buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  
  public A withGcp(io.fabric8.openshift.api.model.hive.gcp.v1.Platform gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new io.fabric8.openshift.api.model.hive.gcp.v1.PlatformBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public GcpGcpNested<A> withNewGcpGcp() {
    return new GcpGcpNested(null);
  }
  
  public GcpGcpNested<A> withNewGcpLike(io.fabric8.openshift.api.model.hive.gcp.v1.Platform item) {
    return new GcpGcpNested(item);
  }
  
  public GcpGcpNested<A> editGcpGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpGcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new io.fabric8.openshift.api.model.hive.gcp.v1.PlatformBuilder().build()));
  }
  
  public GcpGcpNested<A> editOrNewGcpLike(io.fabric8.openshift.api.model.hive.gcp.v1.Platform item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.ibmcloud.v1.Platform buildIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  
  public A withIbmcloud(io.fabric8.openshift.api.model.hive.ibmcloud.v1.Platform ibmcloud) {
    _visitables.get("ibmcloud").remove(this.ibmcloud);
    if (ibmcloud!=null){ this.ibmcloud= new io.fabric8.openshift.api.model.hive.ibmcloud.v1.PlatformBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} else { this.ibmcloud = null; _visitables.get("ibmcloud").remove(this.ibmcloud); } return (A) this;
  }
  
  public boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  
  public IbmcloudIbmcloudNested<A> withNewIbmcloudIbmcloud() {
    return new IbmcloudIbmcloudNested(null);
  }
  
  public IbmcloudIbmcloudNested<A> withNewIbmcloudLike(io.fabric8.openshift.api.model.hive.ibmcloud.v1.Platform item) {
    return new IbmcloudIbmcloudNested(item);
  }
  
  public IbmcloudIbmcloudNested<A> editIbmcloudIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(null));
  }
  
  public IbmcloudIbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(new io.fabric8.openshift.api.model.hive.ibmcloud.v1.PlatformBuilder().build()));
  }
  
  public IbmcloudIbmcloudNested<A> editOrNewIbmcloudLike(io.fabric8.openshift.api.model.hive.ibmcloud.v1.Platform item) {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.none.v1.Platform buildNone() {
    return this.none!=null ?this.none.build():null;
  }
  
  public A withNone(io.fabric8.openshift.api.model.hive.none.v1.Platform none) {
    _visitables.get("none").remove(this.none);
    if (none!=null){ this.none= new io.fabric8.openshift.api.model.hive.none.v1.PlatformBuilder(none); _visitables.get("none").add(this.none);} else { this.none = null; _visitables.get("none").remove(this.none); } return (A) this;
  }
  
  public boolean hasNone() {
    return this.none != null;
  }
  
  public NoneNoneNested<A> withNewNoneNone() {
    return new NoneNoneNested(null);
  }
  
  public NoneNoneNested<A> withNewNoneLike(io.fabric8.openshift.api.model.hive.none.v1.Platform item) {
    return new NoneNoneNested(item);
  }
  
  public NoneNoneNested<A> editNoneNone() {
    return withNewNoneLike(java.util.Optional.ofNullable(buildNone()).orElse(null));
  }
  
  public NoneNoneNested<A> editOrNewNone() {
    return withNewNoneLike(java.util.Optional.ofNullable(buildNone()).orElse(new io.fabric8.openshift.api.model.hive.none.v1.PlatformBuilder().build()));
  }
  
  public NoneNoneNested<A> editOrNewNoneLike(io.fabric8.openshift.api.model.hive.none.v1.Platform item) {
    return withNewNoneLike(java.util.Optional.ofNullable(buildNone()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.openstack.v1.Platform buildOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  
  public A withOpenstack(io.fabric8.openshift.api.model.hive.openstack.v1.Platform openstack) {
    _visitables.get("openstack").remove(this.openstack);
    if (openstack!=null){ this.openstack= new io.fabric8.openshift.api.model.hive.openstack.v1.PlatformBuilder(openstack); _visitables.get("openstack").add(this.openstack);} else { this.openstack = null; _visitables.get("openstack").remove(this.openstack); } return (A) this;
  }
  
  public boolean hasOpenstack() {
    return this.openstack != null;
  }
  
  public OpenstackOpenstackNested<A> withNewOpenstackOpenstack() {
    return new OpenstackOpenstackNested(null);
  }
  
  public OpenstackOpenstackNested<A> withNewOpenstackLike(io.fabric8.openshift.api.model.hive.openstack.v1.Platform item) {
    return new OpenstackOpenstackNested(item);
  }
  
  public OpenstackOpenstackNested<A> editOpenstackOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(null));
  }
  
  public OpenstackOpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(new io.fabric8.openshift.api.model.hive.openstack.v1.PlatformBuilder().build()));
  }
  
  public OpenstackOpenstackNested<A> editOrNewOpenstackLike(io.fabric8.openshift.api.model.hive.openstack.v1.Platform item) {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.ovirt.v1.Platform buildOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  
  public A withOvirt(io.fabric8.openshift.api.model.hive.ovirt.v1.Platform ovirt) {
    _visitables.get("ovirt").remove(this.ovirt);
    if (ovirt!=null){ this.ovirt= new io.fabric8.openshift.api.model.hive.ovirt.v1.PlatformBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} else { this.ovirt = null; _visitables.get("ovirt").remove(this.ovirt); } return (A) this;
  }
  
  public boolean hasOvirt() {
    return this.ovirt != null;
  }
  
  public OvirtOvirtNested<A> withNewOvirtOvirt() {
    return new OvirtOvirtNested(null);
  }
  
  public OvirtOvirtNested<A> withNewOvirtLike(io.fabric8.openshift.api.model.hive.ovirt.v1.Platform item) {
    return new OvirtOvirtNested(item);
  }
  
  public OvirtOvirtNested<A> editOvirtOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(null));
  }
  
  public OvirtOvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(new io.fabric8.openshift.api.model.hive.ovirt.v1.PlatformBuilder().build()));
  }
  
  public OvirtOvirtNested<A> editOrNewOvirtLike(io.fabric8.openshift.api.model.hive.ovirt.v1.Platform item) {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.vsphere.v1.Platform buildVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  
  public A withVsphere(io.fabric8.openshift.api.model.hive.vsphere.v1.Platform vsphere) {
    _visitables.get("vsphere").remove(this.vsphere);
    if (vsphere!=null){ this.vsphere= new io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} else { this.vsphere = null; _visitables.get("vsphere").remove(this.vsphere); } return (A) this;
  }
  
  public boolean hasVsphere() {
    return this.vsphere != null;
  }
  
  public VsphereVsphereNested<A> withNewVsphereVsphere() {
    return new VsphereVsphereNested(null);
  }
  
  public VsphereVsphereNested<A> withNewVsphereLike(io.fabric8.openshift.api.model.hive.vsphere.v1.Platform item) {
    return new VsphereVsphereNested(item);
  }
  
  public VsphereVsphereNested<A> editVsphereVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(null));
  }
  
  public VsphereVsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(new io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder().build()));
  }
  
  public VsphereVsphereNested<A> editOrNewVsphereLike(io.fabric8.openshift.api.model.hive.vsphere.v1.Platform item) {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(agentBareMetal, that.agentBareMetal)) return false;
  
    if (!java.util.Objects.equals(alibabacloud, that.alibabacloud)) return false;
  
    if (!java.util.Objects.equals(aws, that.aws)) return false;
  
    if (!java.util.Objects.equals(azure, that.azure)) return false;
  
    if (!java.util.Objects.equals(baremetal, that.baremetal)) return false;
  
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
  
    if (!java.util.Objects.equals(ibmcloud, that.ibmcloud)) return false;
  
    if (!java.util.Objects.equals(none, that.none)) return false;
  
    if (!java.util.Objects.equals(openstack, that.openstack)) return false;
  
    if (!java.util.Objects.equals(ovirt, that.ovirt)) return false;
  
    if (!java.util.Objects.equals(vsphere, that.vsphere)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(agentBareMetal,  alibabacloud,  aws,  azure,  baremetal,  gcp,  ibmcloud,  none,  openstack,  ovirt,  vsphere,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (agentBareMetal != null) { sb.append("agentBareMetal:"); sb.append(agentBareMetal + ","); }
    if (alibabacloud != null) { sb.append("alibabacloud:"); sb.append(alibabacloud + ","); }
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (none != null) { sb.append("none:"); sb.append(none + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AgentBareMetalNested<N> extends BareMetalPlatformFluent<AgentBareMetalNested<N>> implements Nested<N>{
    AgentBareMetalNested(BareMetalPlatform item) {
      this.builder = new BareMetalPlatformBuilder(this, item);
    }
    BareMetalPlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withAgentBareMetal(builder.build());
    }
    
    public N endAgentBareMetal() {
      return and();
    }
    
  
  }
  public class AlibabacloudNested<N> extends io.fabric8.openshift.api.model.hive.alibabacloud.v1.PlatformFluent<AlibabacloudNested<N>> implements Nested<N>{
    AlibabacloudNested(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withAlibabacloud(builder.build());
    }
    
    public N endAlibabacloud() {
      return and();
    }
    
  
  }
  public class AwsNested<N> extends AwsPlatformFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AwsPlatform item) {
      this.builder = new AwsPlatformBuilder(this, item);
    }
    AwsPlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends AzurePlatformFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(AzurePlatform item) {
      this.builder = new AzurePlatformBuilder(this, item);
    }
    AzurePlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class BaremetalBaremetalNested<N> extends io.fabric8.openshift.api.model.hive.baremetal.v1.PlatformFluent<BaremetalBaremetalNested<N>> implements Nested<N>{
    BaremetalBaremetalNested(io.fabric8.openshift.api.model.hive.baremetal.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.baremetal.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.baremetal.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withBaremetal(builder.build());
    }
    
    public N endBaremetalBaremetal() {
      return and();
    }
    
  
  }
  public class GcpGcpNested<N> extends io.fabric8.openshift.api.model.hive.gcp.v1.PlatformFluent<GcpGcpNested<N>> implements Nested<N>{
    GcpGcpNested(io.fabric8.openshift.api.model.hive.gcp.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.gcp.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.gcp.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withGcp(builder.build());
    }
    
    public N endGcpGcp() {
      return and();
    }
    
  
  }
  public class IbmcloudIbmcloudNested<N> extends io.fabric8.openshift.api.model.hive.ibmcloud.v1.PlatformFluent<IbmcloudIbmcloudNested<N>> implements Nested<N>{
    IbmcloudIbmcloudNested(io.fabric8.openshift.api.model.hive.ibmcloud.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.ibmcloud.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.ibmcloud.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withIbmcloud(builder.build());
    }
    
    public N endIbmcloudIbmcloud() {
      return and();
    }
    
  
  }
  public class NoneNoneNested<N> extends io.fabric8.openshift.api.model.hive.none.v1.PlatformFluent<NoneNoneNested<N>> implements Nested<N>{
    NoneNoneNested(io.fabric8.openshift.api.model.hive.none.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.none.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.none.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withNone(builder.build());
    }
    
    public N endNoneNone() {
      return and();
    }
    
  
  }
  public class OpenstackOpenstackNested<N> extends io.fabric8.openshift.api.model.hive.openstack.v1.PlatformFluent<OpenstackOpenstackNested<N>> implements Nested<N>{
    OpenstackOpenstackNested(io.fabric8.openshift.api.model.hive.openstack.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.openstack.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.openstack.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withOpenstack(builder.build());
    }
    
    public N endOpenstackOpenstack() {
      return and();
    }
    
  
  }
  public class OvirtOvirtNested<N> extends io.fabric8.openshift.api.model.hive.ovirt.v1.PlatformFluent<OvirtOvirtNested<N>> implements Nested<N>{
    OvirtOvirtNested(io.fabric8.openshift.api.model.hive.ovirt.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.ovirt.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.ovirt.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withOvirt(builder.build());
    }
    
    public N endOvirtOvirt() {
      return and();
    }
    
  
  }
  public class VsphereVsphereNested<N> extends io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluent<VsphereVsphereNested<N>> implements Nested<N>{
    VsphereVsphereNested(io.fabric8.openshift.api.model.hive.vsphere.v1.Platform item) {
      this.builder = new io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withVsphere(builder.build());
    }
    
    public N endVsphereVsphere() {
      return and();
    }
    
  
  }

}