package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SyncSetSpecFluent<A extends SyncSetSpecFluent<A>> extends BaseFluent<A>{
  public SyncSetSpecFluent() {
  }
  
  public SyncSetSpecFluent(SyncSetSpec instance) {
    this.copyInstance(instance);
  }
  private String applyBehavior;
  private ArrayList<LocalObjectReferenceBuilder> clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<SyncObjectPatchBuilder> patches = new ArrayList<SyncObjectPatchBuilder>();
  private String resourceApplyMode;
  private List<Map<String,Object>> resources = new ArrayList<Map<String,Object>>();
  private ArrayList<SecretMappingBuilder> secretMappings = new ArrayList<SecretMappingBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SyncSetSpec instance) {
    instance = (instance != null ? instance : new SyncSetSpec());
  
    if (instance != null) {
        this.withApplyBehavior(instance.getApplyBehavior());
        this.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
        this.withPatches(instance.getPatches());
        this.withResourceApplyMode(instance.getResourceApplyMode());
        this.withResources(instance.getResources());
        this.withSecretMappings(instance.getSecretMappings());
        this.withApplyBehavior(instance.getApplyBehavior());
        this.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
        this.withPatches(instance.getPatches());
        this.withResourceApplyMode(instance.getResourceApplyMode());
        this.withResources(instance.getResources());
        this.withSecretMappings(instance.getSecretMappings());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApplyBehavior() {
    return this.applyBehavior;
  }
  
  public A withApplyBehavior(String applyBehavior) {
    this.applyBehavior=applyBehavior; return (A) this;
  }
  
  public boolean hasApplyBehavior() {
    return this.applyBehavior != null;
  }
  
  public A addToClusterDeploymentRefs(int index,LocalObjectReference item) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= clusterDeploymentRefs.size()) { _visitables.get("clusterDeploymentRefs").add(builder); clusterDeploymentRefs.add(builder); } else { _visitables.get("clusterDeploymentRefs").add(index, builder); clusterDeploymentRefs.add(index, builder);}
    return (A)this;
  }
  
  public A setToClusterDeploymentRefs(int index,LocalObjectReference item) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= clusterDeploymentRefs.size()) { _visitables.get("clusterDeploymentRefs").add(builder); clusterDeploymentRefs.add(builder); } else { _visitables.get("clusterDeploymentRefs").set(index, builder); clusterDeploymentRefs.set(index, builder);}
    return (A)this;
  }
  
  public A addToClusterDeploymentRefs(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").add(builder);this.clusterDeploymentRefs.add(builder);} return (A)this;
  }
  
  public A addAllToClusterDeploymentRefs(Collection<LocalObjectReference> items) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").add(builder);this.clusterDeploymentRefs.add(builder);} return (A)this;
  }
  
  public A removeFromClusterDeploymentRefs(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.clusterDeploymentRefs == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").remove(builder); this.clusterDeploymentRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterDeploymentRefs(Collection<LocalObjectReference> items) {
    if (this.clusterDeploymentRefs == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").remove(builder); this.clusterDeploymentRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterDeploymentRefs(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (clusterDeploymentRefs == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = clusterDeploymentRefs.iterator();
    final List visitables = _visitables.get("clusterDeploymentRefs");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildClusterDeploymentRefs() {
    return clusterDeploymentRefs != null ? build(clusterDeploymentRefs) : null;
  }
  
  public LocalObjectReference buildClusterDeploymentRef(int index) {
    return this.clusterDeploymentRefs.get(index).build();
  }
  
  public LocalObjectReference buildFirstClusterDeploymentRef() {
    return this.clusterDeploymentRefs.get(0).build();
  }
  
  public LocalObjectReference buildLastClusterDeploymentRef() {
    return this.clusterDeploymentRefs.get(clusterDeploymentRefs.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingClusterDeploymentRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: clusterDeploymentRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingClusterDeploymentRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: clusterDeploymentRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withClusterDeploymentRefs(List<LocalObjectReference> clusterDeploymentRefs) {
    if (this.clusterDeploymentRefs != null) { _visitables.get("clusterDeploymentRefs").clear();}
    if (clusterDeploymentRefs != null) {this.clusterDeploymentRefs = new ArrayList(); for (LocalObjectReference item : clusterDeploymentRefs){this.addToClusterDeploymentRefs(item);}} else { this.clusterDeploymentRefs = null;} return (A) this;
  }
  
  public A withClusterDeploymentRefs(io.fabric8.kubernetes.api.model.LocalObjectReference... clusterDeploymentRefs) {
    if (this.clusterDeploymentRefs != null) {this.clusterDeploymentRefs.clear(); _visitables.remove("clusterDeploymentRefs"); }
    if (clusterDeploymentRefs != null) {for (LocalObjectReference item :clusterDeploymentRefs){ this.addToClusterDeploymentRefs(item);}} return (A) this;
  }
  
  public boolean hasClusterDeploymentRefs() {
    return clusterDeploymentRefs != null && !clusterDeploymentRefs.isEmpty();
  }
  
  public A addNewClusterDeploymentRef(String name) {
    return (A)addToClusterDeploymentRefs(new LocalObjectReference(name));
  }
  
  public ClusterDeploymentRefsNested<A> addNewClusterDeploymentRef() {
    return new ClusterDeploymentRefsNested(-1, null);
  }
  
  public ClusterDeploymentRefsNested<A> addNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new ClusterDeploymentRefsNested(-1, item);
  }
  
  public ClusterDeploymentRefsNested<A> setNewClusterDeploymentRefLike(int index,LocalObjectReference item) {
    return new ClusterDeploymentRefsNested(index, item);
  }
  
  public ClusterDeploymentRefsNested<A> editClusterDeploymentRef(int index) {
    if (clusterDeploymentRefs.size() <= index) throw new RuntimeException("Can't edit clusterDeploymentRefs. Index exceeds size.");
    return setNewClusterDeploymentRefLike(index, buildClusterDeploymentRef(index));
  }
  
  public ClusterDeploymentRefsNested<A> editFirstClusterDeploymentRef() {
    if (clusterDeploymentRefs.size() == 0) throw new RuntimeException("Can't edit first clusterDeploymentRefs. The list is empty.");
    return setNewClusterDeploymentRefLike(0, buildClusterDeploymentRef(0));
  }
  
  public ClusterDeploymentRefsNested<A> editLastClusterDeploymentRef() {
    int index = clusterDeploymentRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterDeploymentRefs. The list is empty.");
    return setNewClusterDeploymentRefLike(index, buildClusterDeploymentRef(index));
  }
  
  public ClusterDeploymentRefsNested<A> editMatchingClusterDeploymentRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterDeploymentRefs.size();i++) { 
    if (predicate.test(clusterDeploymentRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterDeploymentRefs. No match found.");
    return setNewClusterDeploymentRefLike(index, buildClusterDeploymentRef(index));
  }
  
  public A addToPatches(int index,SyncObjectPatch item) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
    if (index < 0 || index >= patches.size()) { _visitables.get("patches").add(builder); patches.add(builder); } else { _visitables.get("patches").add(index, builder); patches.add(index, builder);}
    return (A)this;
  }
  
  public A setToPatches(int index,SyncObjectPatch item) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
    if (index < 0 || index >= patches.size()) { _visitables.get("patches").add(builder); patches.add(builder); } else { _visitables.get("patches").set(index, builder); patches.set(index, builder);}
    return (A)this;
  }
  
  public A addToPatches(io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch... items) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").add(builder);this.patches.add(builder);} return (A)this;
  }
  
  public A addAllToPatches(Collection<SyncObjectPatch> items) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").add(builder);this.patches.add(builder);} return (A)this;
  }
  
  public A removeFromPatches(io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch... items) {
    if (this.patches == null) return (A)this;
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").remove(builder); this.patches.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPatches(Collection<SyncObjectPatch> items) {
    if (this.patches == null) return (A)this;
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").remove(builder); this.patches.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPatches(Predicate<SyncObjectPatchBuilder> predicate) {
    if (patches == null) return (A) this;
    final Iterator<SyncObjectPatchBuilder> each = patches.iterator();
    final List visitables = _visitables.get("patches");
    while (each.hasNext()) {
      SyncObjectPatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SyncObjectPatch> buildPatches() {
    return patches != null ? build(patches) : null;
  }
  
  public SyncObjectPatch buildPatch(int index) {
    return this.patches.get(index).build();
  }
  
  public SyncObjectPatch buildFirstPatch() {
    return this.patches.get(0).build();
  }
  
  public SyncObjectPatch buildLastPatch() {
    return this.patches.get(patches.size() - 1).build();
  }
  
  public SyncObjectPatch buildMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
    for (SyncObjectPatchBuilder item: patches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
    for (SyncObjectPatchBuilder item: patches) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withPatches(List<SyncObjectPatch> patches) {
    if (this.patches != null) { _visitables.get("patches").clear();}
    if (patches != null) {this.patches = new ArrayList(); for (SyncObjectPatch item : patches){this.addToPatches(item);}} else { this.patches = null;} return (A) this;
  }
  
  public A withPatches(io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch... patches) {
    if (this.patches != null) {this.patches.clear(); _visitables.remove("patches"); }
    if (patches != null) {for (SyncObjectPatch item :patches){ this.addToPatches(item);}} return (A) this;
  }
  
  public boolean hasPatches() {
    return patches != null && !patches.isEmpty();
  }
  
  public PatchesNested<A> addNewPatch() {
    return new PatchesNested(-1, null);
  }
  
  public PatchesNested<A> addNewPatchLike(SyncObjectPatch item) {
    return new PatchesNested(-1, item);
  }
  
  public PatchesNested<A> setNewPatchLike(int index,SyncObjectPatch item) {
    return new PatchesNested(index, item);
  }
  
  public PatchesNested<A> editPatch(int index) {
    if (patches.size() <= index) throw new RuntimeException("Can't edit patches. Index exceeds size.");
    return setNewPatchLike(index, buildPatch(index));
  }
  
  public PatchesNested<A> editFirstPatch() {
    if (patches.size() == 0) throw new RuntimeException("Can't edit first patches. The list is empty.");
    return setNewPatchLike(0, buildPatch(0));
  }
  
  public PatchesNested<A> editLastPatch() {
    int index = patches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last patches. The list is empty.");
    return setNewPatchLike(index, buildPatch(index));
  }
  
  public PatchesNested<A> editMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<patches.size();i++) { 
    if (predicate.test(patches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching patches. No match found.");
    return setNewPatchLike(index, buildPatch(index));
  }
  
  public String getResourceApplyMode() {
    return this.resourceApplyMode;
  }
  
  public A withResourceApplyMode(String resourceApplyMode) {
    this.resourceApplyMode=resourceApplyMode; return (A) this;
  }
  
  public boolean hasResourceApplyMode() {
    return this.resourceApplyMode != null;
  }
  
  public A addToResources(int index,Map<String,Object> item) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    this.resources.add(index, item);
    return (A)this;
  }
  
  public A setToResources(int index,Map<String,Object> item) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    this.resources.set(index, item); return (A)this;
  }
  
  public A addToResources(Map<String,Object>... items) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.resources.add(item);} return (A)this;
  }
  
  public A addAllToResources(Collection<Map<String,Object>> items) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.resources.add(item);} return (A)this;
  }
  
  public A removeFromResources(Map<String,Object>... items) {
    if (this.resources == null) return (A)this;
    for (Map<String,Object> item : items) { this.resources.remove(item);} return (A)this;
  }
  
  public A removeAllFromResources(Collection<Map<String,Object>> items) {
    if (this.resources == null) return (A)this;
    for (Map<String,Object> item : items) { this.resources.remove(item);} return (A)this;
  }
  
  public List<Map<String,Object>> getResources() {
    return this.resources;
  }
  
  public Map<String,Object> getResource(int index) {
    return this.resources.get(index);
  }
  
  public Map<String,Object> getFirstResource() {
    return this.resources.get(0);
  }
  
  public Map<String,Object> getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  
  public Map<String,Object> getMatchingResource(Predicate<Map<String,Object>> predicate) {
    for (Map<String,Object> item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingResource(Predicate<Map<String,Object>> predicate) {
    for (Map<String,Object> item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public <K,V>A withResources(List<Map<String,Object>> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (Map<String,Object> item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  
  public A withResources(Map<String,Object>... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (Map<String,Object> item :resources){ this.addToResources(item);}} return (A) this;
  }
  
  public boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  
  public A addToSecretMappings(int index,SecretMapping item) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    SecretMappingBuilder builder = new SecretMappingBuilder(item);
    if (index < 0 || index >= secretMappings.size()) { _visitables.get("secretMappings").add(builder); secretMappings.add(builder); } else { _visitables.get("secretMappings").add(index, builder); secretMappings.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecretMappings(int index,SecretMapping item) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    SecretMappingBuilder builder = new SecretMappingBuilder(item);
    if (index < 0 || index >= secretMappings.size()) { _visitables.get("secretMappings").add(builder); secretMappings.add(builder); } else { _visitables.get("secretMappings").set(index, builder); secretMappings.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecretMappings(io.fabric8.openshift.api.model.hive.v1.SecretMapping... items) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").add(builder);this.secretMappings.add(builder);} return (A)this;
  }
  
  public A addAllToSecretMappings(Collection<SecretMapping> items) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").add(builder);this.secretMappings.add(builder);} return (A)this;
  }
  
  public A removeFromSecretMappings(io.fabric8.openshift.api.model.hive.v1.SecretMapping... items) {
    if (this.secretMappings == null) return (A)this;
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").remove(builder); this.secretMappings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecretMappings(Collection<SecretMapping> items) {
    if (this.secretMappings == null) return (A)this;
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").remove(builder); this.secretMappings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecretMappings(Predicate<SecretMappingBuilder> predicate) {
    if (secretMappings == null) return (A) this;
    final Iterator<SecretMappingBuilder> each = secretMappings.iterator();
    final List visitables = _visitables.get("secretMappings");
    while (each.hasNext()) {
      SecretMappingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SecretMapping> buildSecretMappings() {
    return secretMappings != null ? build(secretMappings) : null;
  }
  
  public SecretMapping buildSecretMapping(int index) {
    return this.secretMappings.get(index).build();
  }
  
  public SecretMapping buildFirstSecretMapping() {
    return this.secretMappings.get(0).build();
  }
  
  public SecretMapping buildLastSecretMapping() {
    return this.secretMappings.get(secretMappings.size() - 1).build();
  }
  
  public SecretMapping buildMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
    for (SecretMappingBuilder item: secretMappings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
    for (SecretMappingBuilder item: secretMappings) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSecretMappings(List<SecretMapping> secretMappings) {
    if (this.secretMappings != null) { _visitables.get("secretMappings").clear();}
    if (secretMappings != null) {this.secretMappings = new ArrayList(); for (SecretMapping item : secretMappings){this.addToSecretMappings(item);}} else { this.secretMappings = null;} return (A) this;
  }
  
  public A withSecretMappings(io.fabric8.openshift.api.model.hive.v1.SecretMapping... secretMappings) {
    if (this.secretMappings != null) {this.secretMappings.clear(); _visitables.remove("secretMappings"); }
    if (secretMappings != null) {for (SecretMapping item :secretMappings){ this.addToSecretMappings(item);}} return (A) this;
  }
  
  public boolean hasSecretMappings() {
    return secretMappings != null && !secretMappings.isEmpty();
  }
  
  public SecretMappingsNested<A> addNewSecretMapping() {
    return new SecretMappingsNested(-1, null);
  }
  
  public SecretMappingsNested<A> addNewSecretMappingLike(SecretMapping item) {
    return new SecretMappingsNested(-1, item);
  }
  
  public SecretMappingsNested<A> setNewSecretMappingLike(int index,SecretMapping item) {
    return new SecretMappingsNested(index, item);
  }
  
  public SecretMappingsNested<A> editSecretMapping(int index) {
    if (secretMappings.size() <= index) throw new RuntimeException("Can't edit secretMappings. Index exceeds size.");
    return setNewSecretMappingLike(index, buildSecretMapping(index));
  }
  
  public SecretMappingsNested<A> editFirstSecretMapping() {
    if (secretMappings.size() == 0) throw new RuntimeException("Can't edit first secretMappings. The list is empty.");
    return setNewSecretMappingLike(0, buildSecretMapping(0));
  }
  
  public SecretMappingsNested<A> editLastSecretMapping() {
    int index = secretMappings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secretMappings. The list is empty.");
    return setNewSecretMappingLike(index, buildSecretMapping(index));
  }
  
  public SecretMappingsNested<A> editMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secretMappings.size();i++) { 
    if (predicate.test(secretMappings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secretMappings. No match found.");
    return setNewSecretMappingLike(index, buildSecretMapping(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SyncSetSpecFluent that = (SyncSetSpecFluent) o;
    if (!java.util.Objects.equals(applyBehavior, that.applyBehavior)) return false;
  
    if (!java.util.Objects.equals(clusterDeploymentRefs, that.clusterDeploymentRefs)) return false;
  
    if (!java.util.Objects.equals(patches, that.patches)) return false;
  
    if (!java.util.Objects.equals(resourceApplyMode, that.resourceApplyMode)) return false;
  
    if (!java.util.Objects.equals(resources, that.resources)) return false;
  
    if (!java.util.Objects.equals(secretMappings, that.secretMappings)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(applyBehavior,  clusterDeploymentRefs,  patches,  resourceApplyMode,  resources,  secretMappings,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applyBehavior != null) { sb.append("applyBehavior:"); sb.append(applyBehavior + ","); }
    if (clusterDeploymentRefs != null && !clusterDeploymentRefs.isEmpty()) { sb.append("clusterDeploymentRefs:"); sb.append(clusterDeploymentRefs + ","); }
    if (patches != null && !patches.isEmpty()) { sb.append("patches:"); sb.append(patches + ","); }
    if (resourceApplyMode != null) { sb.append("resourceApplyMode:"); sb.append(resourceApplyMode + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (secretMappings != null && !secretMappings.isEmpty()) { sb.append("secretMappings:"); sb.append(secretMappings + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterDeploymentRefsNested<N> extends LocalObjectReferenceFluent<ClusterDeploymentRefsNested<N>> implements Nested<N>{
    ClusterDeploymentRefsNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) SyncSetSpecFluent.this.setToClusterDeploymentRefs(index,builder.build());
    }
    
    public N endClusterDeploymentRef() {
      return and();
    }
    
  
  }
  public class PatchesNested<N> extends SyncObjectPatchFluent<PatchesNested<N>> implements Nested<N>{
    PatchesNested(int index,SyncObjectPatch item) {
      this.index = index;
      this.builder = new SyncObjectPatchBuilder(this, item);
    }
    SyncObjectPatchBuilder builder;
    int index;
    
    public N and() {
      return (N) SyncSetSpecFluent.this.setToPatches(index,builder.build());
    }
    
    public N endPatch() {
      return and();
    }
    
  
  }
  public class SecretMappingsNested<N> extends SecretMappingFluent<SecretMappingsNested<N>> implements Nested<N>{
    SecretMappingsNested(int index,SecretMapping item) {
      this.index = index;
      this.builder = new SecretMappingBuilder(this, item);
    }
    SecretMappingBuilder builder;
    int index;
    
    public N and() {
      return (N) SyncSetSpecFluent.this.setToSecretMappings(index,builder.build());
    }
    
    public N endSecretMapping() {
      return and();
    }
    
  
  }

}