/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState;
import io.fabric8.openshift.api.model.hive.v1.ClusterOperatorStateBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterOperatorStateFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterStateStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterStateStatusFluent<A extends ClusterStateStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterOperatorStateBuilder> clusterOperators = new ArrayList();
    private String lastUpdated;
    private Map<String, Object> additionalProperties;

    public ClusterStateStatusFluent() {
    }

    public ClusterStateStatusFluent(ClusterStateStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterStateStatus instance) {
        ClusterStateStatus clusterStateStatus = instance = instance != null ? instance : new ClusterStateStatus();
        if (instance != null) {
            this.withClusterOperators(instance.getClusterOperators());
            this.withLastUpdated(instance.getLastUpdated());
            this.withClusterOperators(instance.getClusterOperators());
            this.withLastUpdated(instance.getLastUpdated());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToClusterOperators(int index, ClusterOperatorState item) {
        if (this.clusterOperators == null) {
            this.clusterOperators = new ArrayList();
        }
        ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
        if (index < 0 || index >= this.clusterOperators.size()) {
            this._visitables.get((Object)"clusterOperators").add(builder);
            this.clusterOperators.add(builder);
        } else {
            this._visitables.get((Object)"clusterOperators").add(index, builder);
            this.clusterOperators.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusterOperators(int index, ClusterOperatorState item) {
        if (this.clusterOperators == null) {
            this.clusterOperators = new ArrayList();
        }
        ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
        if (index < 0 || index >= this.clusterOperators.size()) {
            this._visitables.get((Object)"clusterOperators").add(builder);
            this.clusterOperators.add(builder);
        } else {
            this._visitables.get((Object)"clusterOperators").set(index, builder);
            this.clusterOperators.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusterOperators(ClusterOperatorState ... items) {
        if (this.clusterOperators == null) {
            this.clusterOperators = new ArrayList();
        }
        for (ClusterOperatorState item : items) {
            ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
            this._visitables.get((Object)"clusterOperators").add(builder);
            this.clusterOperators.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterOperators(Collection<ClusterOperatorState> items) {
        if (this.clusterOperators == null) {
            this.clusterOperators = new ArrayList();
        }
        for (ClusterOperatorState item : items) {
            ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
            this._visitables.get((Object)"clusterOperators").add(builder);
            this.clusterOperators.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterOperators(ClusterOperatorState ... items) {
        if (this.clusterOperators == null) {
            return (A)((Object)this);
        }
        for (ClusterOperatorState item : items) {
            ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
            this._visitables.get((Object)"clusterOperators").remove((Object)builder);
            this.clusterOperators.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterOperators(Collection<ClusterOperatorState> items) {
        if (this.clusterOperators == null) {
            return (A)((Object)this);
        }
        for (ClusterOperatorState item : items) {
            ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
            this._visitables.get((Object)"clusterOperators").remove((Object)builder);
            this.clusterOperators.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusterOperators(Predicate<ClusterOperatorStateBuilder> predicate) {
        if (this.clusterOperators == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterOperatorStateBuilder> each = this.clusterOperators.iterator();
        List visitables = this._visitables.get((Object)"clusterOperators");
        while (each.hasNext()) {
            ClusterOperatorStateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterOperatorState> buildClusterOperators() {
        return this.clusterOperators != null ? ClusterStateStatusFluent.build(this.clusterOperators) : null;
    }

    public ClusterOperatorState buildClusterOperator(int index) {
        return this.clusterOperators.get(index).build();
    }

    public ClusterOperatorState buildFirstClusterOperator() {
        return this.clusterOperators.get(0).build();
    }

    public ClusterOperatorState buildLastClusterOperator() {
        return this.clusterOperators.get(this.clusterOperators.size() - 1).build();
    }

    public ClusterOperatorState buildMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
        for (ClusterOperatorStateBuilder item : this.clusterOperators) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
        for (ClusterOperatorStateBuilder item : this.clusterOperators) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterOperators(List<ClusterOperatorState> clusterOperators) {
        if (this.clusterOperators != null) {
            this._visitables.get((Object)"clusterOperators").clear();
        }
        if (clusterOperators != null) {
            this.clusterOperators = new ArrayList();
            for (ClusterOperatorState item : clusterOperators) {
                this.addToClusterOperators(item);
            }
        } else {
            this.clusterOperators = null;
        }
        return (A)((Object)this);
    }

    public A withClusterOperators(ClusterOperatorState ... clusterOperators) {
        if (this.clusterOperators != null) {
            this.clusterOperators.clear();
            this._visitables.remove((Object)"clusterOperators");
        }
        if (clusterOperators != null) {
            for (ClusterOperatorState item : clusterOperators) {
                this.addToClusterOperators(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterOperators() {
        return this.clusterOperators != null && !this.clusterOperators.isEmpty();
    }

    public ClusterOperatorsNested<A> addNewClusterOperator() {
        return new ClusterOperatorsNested(-1, null);
    }

    public ClusterOperatorsNested<A> addNewClusterOperatorLike(ClusterOperatorState item) {
        return new ClusterOperatorsNested(-1, item);
    }

    public ClusterOperatorsNested<A> setNewClusterOperatorLike(int index, ClusterOperatorState item) {
        return new ClusterOperatorsNested(index, item);
    }

    public ClusterOperatorsNested<A> editClusterOperator(int index) {
        if (this.clusterOperators.size() <= index) {
            throw new RuntimeException("Can't edit clusterOperators. Index exceeds size.");
        }
        return this.setNewClusterOperatorLike(index, this.buildClusterOperator(index));
    }

    public ClusterOperatorsNested<A> editFirstClusterOperator() {
        if (this.clusterOperators.size() == 0) {
            throw new RuntimeException("Can't edit first clusterOperators. The list is empty.");
        }
        return this.setNewClusterOperatorLike(0, this.buildClusterOperator(0));
    }

    public ClusterOperatorsNested<A> editLastClusterOperator() {
        int index = this.clusterOperators.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterOperators. The list is empty.");
        }
        return this.setNewClusterOperatorLike(index, this.buildClusterOperator(index));
    }

    public ClusterOperatorsNested<A> editMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterOperators.size(); ++i) {
            if (!predicate.test(this.clusterOperators.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterOperators. No match found.");
        }
        return this.setNewClusterOperatorLike(index, this.buildClusterOperator(index));
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)((Object)this);
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterStateStatusFluent that = (ClusterStateStatusFluent)((Object)o);
        if (!Objects.equals(this.clusterOperators, that.clusterOperators)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterOperators, this.lastUpdated, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterOperators != null && !this.clusterOperators.isEmpty()) {
            sb.append("clusterOperators:");
            sb.append(this.clusterOperators + ",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterOperatorsNested<N>
    extends ClusterOperatorStateFluent<ClusterOperatorsNested<N>>
    implements Nested<N> {
        ClusterOperatorStateBuilder builder;
        int index;

        ClusterOperatorsNested(int index, ClusterOperatorState item) {
            this.index = index;
            this.builder = new ClusterOperatorStateBuilder(this, item);
        }

        public N and() {
            return (N)ClusterStateStatusFluent.this.setToClusterOperators(this.index, this.builder.build());
        }

        public N endClusterOperator() {
            return this.and();
        }
    }
}

