package io.fabric8.openshift.api.model.hive.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AwsPlatformFluent<A extends AwsPlatformFluent<A>> extends BaseFluent<A>{
  public AwsPlatformFluent() {
  }
  
  public AwsPlatformFluent(AwsPlatform instance) {
    this.copyInstance(instance);
  }
  private AssumeRoleBuilder credentialsAssumeRole;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private PrivateLinkAccessBuilder privateLink;
  private String region;
  private Map<String,String> userTags;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AwsPlatform instance) {
    instance = (instance != null ? instance : new AwsPlatform());
    if (instance != null) {
          this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
          this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
          this.withPrivateLink(instance.getPrivateLink());
          this.withRegion(instance.getRegion());
          this.withUserTags(instance.getUserTags());
          this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
          this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
          this.withPrivateLink(instance.getPrivateLink());
          this.withRegion(instance.getRegion());
          this.withUserTags(instance.getUserTags());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AssumeRole buildCredentialsAssumeRole() {
    return this.credentialsAssumeRole != null ? this.credentialsAssumeRole.build() : null;
  }
  
  public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
    this._visitables.remove(this.credentialsAssumeRole);
    if (credentialsAssumeRole != null) {
        this.credentialsAssumeRole = new AssumeRoleBuilder(credentialsAssumeRole);
        this._visitables.get("credentialsAssumeRole").add(this.credentialsAssumeRole);
    } else {
        this.credentialsAssumeRole = null;
        this._visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole);
    }
    return (A) this;
  }
  
  public boolean hasCredentialsAssumeRole() {
    return this.credentialsAssumeRole != null;
  }
  
  public A withNewCredentialsAssumeRole(String externalID,String roleARN) {
    return (A)withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
  }
  
  public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
    return new CredentialsAssumeRoleNested(null);
  }
  
  public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
    return new CredentialsAssumeRoleNested(item);
  }
  
  public CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(java.util.Optional.ofNullable(buildCredentialsAssumeRole()).orElse(null));
  }
  
  public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(java.util.Optional.ofNullable(buildCredentialsAssumeRole()).orElse(new AssumeRoleBuilder().build()));
  }
  
  public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
    return withNewCredentialsAssumeRoleLike(java.util.Optional.ofNullable(buildCredentialsAssumeRole()).orElse(item));
  }
  
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
  }
  
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    this._visitables.remove(this.credentialsSecretRef);
    if (credentialsSecretRef != null) {
        this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
        this._visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);
    } else {
        this.credentialsSecretRef = null;
        this._visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new CredentialsSecretRefNested(null);
  }
  
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new CredentialsSecretRefNested(item);
  }
  
  public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(null));
  }
  
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(item));
  }
  
  public PrivateLinkAccess buildPrivateLink() {
    return this.privateLink != null ? this.privateLink.build() : null;
  }
  
  public A withPrivateLink(PrivateLinkAccess privateLink) {
    this._visitables.remove(this.privateLink);
    if (privateLink != null) {
        this.privateLink = new PrivateLinkAccessBuilder(privateLink);
        this._visitables.get("privateLink").add(this.privateLink);
    } else {
        this.privateLink = null;
        this._visitables.get("privateLink").remove(this.privateLink);
    }
    return (A) this;
  }
  
  public boolean hasPrivateLink() {
    return this.privateLink != null;
  }
  
  public PrivateLinkNested<A> withNewPrivateLink() {
    return new PrivateLinkNested(null);
  }
  
  public PrivateLinkNested<A> withNewPrivateLinkLike(PrivateLinkAccess item) {
    return new PrivateLinkNested(item);
  }
  
  public PrivateLinkNested<A> editPrivateLink() {
    return withNewPrivateLinkLike(java.util.Optional.ofNullable(buildPrivateLink()).orElse(null));
  }
  
  public PrivateLinkNested<A> editOrNewPrivateLink() {
    return withNewPrivateLinkLike(java.util.Optional.ofNullable(buildPrivateLink()).orElse(new PrivateLinkAccessBuilder().build()));
  }
  
  public PrivateLinkNested<A> editOrNewPrivateLinkLike(PrivateLinkAccess item) {
    return withNewPrivateLinkLike(java.util.Optional.ofNullable(buildPrivateLink()).orElse(item));
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToUserTags(String key,String value) {
    if(this.userTags == null && key != null && value != null) { this.userTags = new LinkedHashMap(); }
    if(key != null && value != null) {this.userTags.put(key, value);} return (A)this;
  }
  
  public A addToUserTags(Map<String,String> map) {
    if(this.userTags == null && map != null) { this.userTags = new LinkedHashMap(); }
    if(map != null) { this.userTags.putAll(map);} return (A)this;
  }
  
  public A removeFromUserTags(String key) {
    if(this.userTags == null) { return (A) this; }
    if(key != null && this.userTags != null) {this.userTags.remove(key);} return (A)this;
  }
  
  public A removeFromUserTags(Map<String,String> map) {
    if(this.userTags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.userTags != null){this.userTags.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getUserTags() {
    return this.userTags;
  }
  
  public <K,V>A withUserTags(Map<String,String> userTags) {
    if (userTags == null) {
      this.userTags = null;
    } else {
      this.userTags = new LinkedHashMap(userTags);
    }
    return (A) this;
  }
  
  public boolean hasUserTags() {
    return this.userTags != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AwsPlatformFluent that = (AwsPlatformFluent) o;
    if (!java.util.Objects.equals(credentialsAssumeRole, that.credentialsAssumeRole)) return false;
    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;
    if (!java.util.Objects.equals(privateLink, that.privateLink)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(userTags, that.userTags)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(credentialsAssumeRole,  credentialsSecretRef,  privateLink,  region,  userTags,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentialsAssumeRole != null) { sb.append("credentialsAssumeRole:"); sb.append(credentialsAssumeRole + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (privateLink != null) { sb.append("privateLink:"); sb.append(privateLink + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (userTags != null && !userTags.isEmpty()) { sb.append("userTags:"); sb.append(userTags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CredentialsAssumeRoleNested<N> extends AssumeRoleFluent<CredentialsAssumeRoleNested<N>> implements Nested<N>{
    CredentialsAssumeRoleNested(AssumeRole item) {
      this.builder = new AssumeRoleBuilder(this, item);
    }
    AssumeRoleBuilder builder;
    
    public N and() {
      return (N) AwsPlatformFluent.this.withCredentialsAssumeRole(builder.build());
    }
    
    public N endCredentialsAssumeRole() {
      return and();
    }
    
  
  }
  public class CredentialsSecretRefNested<N> extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>> implements Nested<N>{
    CredentialsSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) AwsPlatformFluent.this.withCredentialsSecretRef(builder.build());
    }
    
    public N endCredentialsSecretRef() {
      return and();
    }
    
  
  }
  public class PrivateLinkNested<N> extends PrivateLinkAccessFluent<PrivateLinkNested<N>> implements Nested<N>{
    PrivateLinkNested(PrivateLinkAccess item) {
      this.builder = new PrivateLinkAccessBuilder(this, item);
    }
    PrivateLinkAccessBuilder builder;
    
    public N and() {
      return (N) AwsPlatformFluent.this.withPrivateLink(builder.build());
    }
    
    public N endPrivateLink() {
      return and();
    }
    
  
  }

}