package io.fabric8.openshift.api.model.hive.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AwsPlatformStatusFluent<A extends AwsPlatformStatusFluent<A>> extends BaseFluent<A>{
  public AwsPlatformStatusFluent() {
  }
  
  public AwsPlatformStatusFluent(AwsPlatformStatus instance) {
    this.copyInstance(instance);
  }
  private PrivateLinkAccessStatusBuilder privateLink;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AwsPlatformStatus instance) {
    instance = (instance != null ? instance : new AwsPlatformStatus());
    if (instance != null) {
          this.withPrivateLink(instance.getPrivateLink());
          this.withPrivateLink(instance.getPrivateLink());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PrivateLinkAccessStatus buildPrivateLink() {
    return this.privateLink != null ? this.privateLink.build() : null;
  }
  
  public A withPrivateLink(PrivateLinkAccessStatus privateLink) {
    this._visitables.remove(this.privateLink);
    if (privateLink != null) {
        this.privateLink = new PrivateLinkAccessStatusBuilder(privateLink);
        this._visitables.get("privateLink").add(this.privateLink);
    } else {
        this.privateLink = null;
        this._visitables.get("privateLink").remove(this.privateLink);
    }
    return (A) this;
  }
  
  public boolean hasPrivateLink() {
    return this.privateLink != null;
  }
  
  public PrivateLinkNested<A> withNewPrivateLink() {
    return new PrivateLinkNested(null);
  }
  
  public PrivateLinkNested<A> withNewPrivateLinkLike(PrivateLinkAccessStatus item) {
    return new PrivateLinkNested(item);
  }
  
  public PrivateLinkNested<A> editPrivateLink() {
    return withNewPrivateLinkLike(java.util.Optional.ofNullable(buildPrivateLink()).orElse(null));
  }
  
  public PrivateLinkNested<A> editOrNewPrivateLink() {
    return withNewPrivateLinkLike(java.util.Optional.ofNullable(buildPrivateLink()).orElse(new PrivateLinkAccessStatusBuilder().build()));
  }
  
  public PrivateLinkNested<A> editOrNewPrivateLinkLike(PrivateLinkAccessStatus item) {
    return withNewPrivateLinkLike(java.util.Optional.ofNullable(buildPrivateLink()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AwsPlatformStatusFluent that = (AwsPlatformStatusFluent) o;
    if (!java.util.Objects.equals(privateLink, that.privateLink)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(privateLink,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (privateLink != null) { sb.append("privateLink:"); sb.append(privateLink + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PrivateLinkNested<N> extends PrivateLinkAccessStatusFluent<PrivateLinkNested<N>> implements Nested<N>{
    PrivateLinkNested(PrivateLinkAccessStatus item) {
      this.builder = new PrivateLinkAccessStatusBuilder(this, item);
    }
    PrivateLinkAccessStatusBuilder builder;
    
    public N and() {
      return (N) AwsPlatformStatusFluent.this.withPrivateLink(builder.build());
    }
    
    public N endPrivateLink() {
      return and();
    }
    
  
  }

}