package io.fabric8.openshift.api.model.hive.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VPCEndpointServiceFluent<A extends VPCEndpointServiceFluent<A>> extends BaseFluent<A>{
  public VPCEndpointServiceFluent() {
  }
  
  public VPCEndpointServiceFluent(VPCEndpointService instance) {
    this.copyInstance(instance);
  }
  private List<String> additionalAllowedPrincipals = new ArrayList<String>();
  private String defaultAllowedPrincipal;
  private String id;
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VPCEndpointService instance) {
    instance = (instance != null ? instance : new VPCEndpointService());
    if (instance != null) {
          this.withAdditionalAllowedPrincipals(instance.getAdditionalAllowedPrincipals());
          this.withDefaultAllowedPrincipal(instance.getDefaultAllowedPrincipal());
          this.withId(instance.getId());
          this.withName(instance.getName());
          this.withAdditionalAllowedPrincipals(instance.getAdditionalAllowedPrincipals());
          this.withDefaultAllowedPrincipal(instance.getDefaultAllowedPrincipal());
          this.withId(instance.getId());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalAllowedPrincipals(int index,String item) {
    if (this.additionalAllowedPrincipals == null) {this.additionalAllowedPrincipals = new ArrayList<String>();}
    this.additionalAllowedPrincipals.add(index, item);
    return (A)this;
  }
  
  public A setToAdditionalAllowedPrincipals(int index,String item) {
    if (this.additionalAllowedPrincipals == null) {this.additionalAllowedPrincipals = new ArrayList<String>();}
    this.additionalAllowedPrincipals.set(index, item); return (A)this;
  }
  
  public A addToAdditionalAllowedPrincipals(java.lang.String... items) {
    if (this.additionalAllowedPrincipals == null) {this.additionalAllowedPrincipals = new ArrayList<String>();}
    for (String item : items) {this.additionalAllowedPrincipals.add(item);} return (A)this;
  }
  
  public A addAllToAdditionalAllowedPrincipals(Collection<String> items) {
    if (this.additionalAllowedPrincipals == null) {this.additionalAllowedPrincipals = new ArrayList<String>();}
    for (String item : items) {this.additionalAllowedPrincipals.add(item);} return (A)this;
  }
  
  public A removeFromAdditionalAllowedPrincipals(java.lang.String... items) {
    if (this.additionalAllowedPrincipals == null) return (A)this;
    for (String item : items) { this.additionalAllowedPrincipals.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdditionalAllowedPrincipals(Collection<String> items) {
    if (this.additionalAllowedPrincipals == null) return (A)this;
    for (String item : items) { this.additionalAllowedPrincipals.remove(item);} return (A)this;
  }
  
  public List<String> getAdditionalAllowedPrincipals() {
    return this.additionalAllowedPrincipals;
  }
  
  public String getAdditionalAllowedPrincipal(int index) {
    return this.additionalAllowedPrincipals.get(index);
  }
  
  public String getFirstAdditionalAllowedPrincipal() {
    return this.additionalAllowedPrincipals.get(0);
  }
  
  public String getLastAdditionalAllowedPrincipal() {
    return this.additionalAllowedPrincipals.get(additionalAllowedPrincipals.size() - 1);
  }
  
  public String getMatchingAdditionalAllowedPrincipal(Predicate<String> predicate) {
      for (String item : additionalAllowedPrincipals) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalAllowedPrincipal(Predicate<String> predicate) {
      for (String item : additionalAllowedPrincipals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalAllowedPrincipals(List<String> additionalAllowedPrincipals) {
    if (additionalAllowedPrincipals != null) {
        this.additionalAllowedPrincipals = new ArrayList();
        for (String item : additionalAllowedPrincipals) {
          this.addToAdditionalAllowedPrincipals(item);
        }
    } else {
      this.additionalAllowedPrincipals = null;
    }
    return (A) this;
  }
  
  public A withAdditionalAllowedPrincipals(java.lang.String... additionalAllowedPrincipals) {
    if (this.additionalAllowedPrincipals != null) {this.additionalAllowedPrincipals.clear(); _visitables.remove("additionalAllowedPrincipals"); }
    if (additionalAllowedPrincipals != null) {for (String item :additionalAllowedPrincipals){ this.addToAdditionalAllowedPrincipals(item);}} return (A) this;
  }
  
  public boolean hasAdditionalAllowedPrincipals() {
    return this.additionalAllowedPrincipals != null && !this.additionalAllowedPrincipals.isEmpty();
  }
  
  public String getDefaultAllowedPrincipal() {
    return this.defaultAllowedPrincipal;
  }
  
  public A withDefaultAllowedPrincipal(String defaultAllowedPrincipal) {
    this.defaultAllowedPrincipal = defaultAllowedPrincipal;
    return (A) this;
  }
  
  public boolean hasDefaultAllowedPrincipal() {
    return this.defaultAllowedPrincipal != null;
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VPCEndpointServiceFluent that = (VPCEndpointServiceFluent) o;
    if (!java.util.Objects.equals(additionalAllowedPrincipals, that.additionalAllowedPrincipals)) return false;
    if (!java.util.Objects.equals(defaultAllowedPrincipal, that.defaultAllowedPrincipal)) return false;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalAllowedPrincipals,  defaultAllowedPrincipal,  id,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalAllowedPrincipals != null && !additionalAllowedPrincipals.isEmpty()) { sb.append("additionalAllowedPrincipals:"); sb.append(additionalAllowedPrincipals + ","); }
    if (defaultAllowedPrincipal != null) { sb.append("defaultAllowedPrincipal:"); sb.append(defaultAllowedPrincipal + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}