package io.fabric8.openshift.api.model.hive.ovirt.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private CPUBuilder cpu;
  private Integer memoryMB;
  private DiskBuilder osDisk;
  private String vmType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withCpu(instance.getCpu());
          this.withMemoryMB(instance.getMemoryMB());
          this.withOsDisk(instance.getOsDisk());
          this.withVmType(instance.getVmType());
          this.withCpu(instance.getCpu());
          this.withMemoryMB(instance.getMemoryMB());
          this.withOsDisk(instance.getOsDisk());
          this.withVmType(instance.getVmType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public CPU buildCpu() {
    return this.cpu != null ? this.cpu.build() : null;
  }
  
  public A withCpu(CPU cpu) {
    this._visitables.remove(this.cpu);
    if (cpu != null) {
        this.cpu = new CPUBuilder(cpu);
        this._visitables.get("cpu").add(this.cpu);
    } else {
        this.cpu = null;
        this._visitables.get("cpu").remove(this.cpu);
    }
    return (A) this;
  }
  
  public boolean hasCpu() {
    return this.cpu != null;
  }
  
  public A withNewCpu(Integer cores,Integer sockets) {
    return (A)withCpu(new CPU(cores, sockets));
  }
  
  public CpuNested<A> withNewCpu() {
    return new CpuNested(null);
  }
  
  public CpuNested<A> withNewCpuLike(CPU item) {
    return new CpuNested(item);
  }
  
  public CpuNested<A> editCpu() {
    return withNewCpuLike(java.util.Optional.ofNullable(buildCpu()).orElse(null));
  }
  
  public CpuNested<A> editOrNewCpu() {
    return withNewCpuLike(java.util.Optional.ofNullable(buildCpu()).orElse(new CPUBuilder().build()));
  }
  
  public CpuNested<A> editOrNewCpuLike(CPU item) {
    return withNewCpuLike(java.util.Optional.ofNullable(buildCpu()).orElse(item));
  }
  
  public Integer getMemoryMB() {
    return this.memoryMB;
  }
  
  public A withMemoryMB(Integer memoryMB) {
    this.memoryMB = memoryMB;
    return (A) this;
  }
  
  public boolean hasMemoryMB() {
    return this.memoryMB != null;
  }
  
  public Disk buildOsDisk() {
    return this.osDisk != null ? this.osDisk.build() : null;
  }
  
  public A withOsDisk(Disk osDisk) {
    this._visitables.remove(this.osDisk);
    if (osDisk != null) {
        this.osDisk = new DiskBuilder(osDisk);
        this._visitables.get("osDisk").add(this.osDisk);
    } else {
        this.osDisk = null;
        this._visitables.get("osDisk").remove(this.osDisk);
    }
    return (A) this;
  }
  
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  
  public A withNewOsDisk(Long sizeGB) {
    return (A)withOsDisk(new Disk(sizeGB));
  }
  
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  
  public OsDiskNested<A> withNewOsDiskLike(Disk item) {
    return new OsDiskNested(item);
  }
  
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new DiskBuilder().build()));
  }
  
  public OsDiskNested<A> editOrNewOsDiskLike(Disk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  
  public String getVmType() {
    return this.vmType;
  }
  
  public A withVmType(String vmType) {
    this.vmType = vmType;
    return (A) this;
  }
  
  public boolean hasVmType() {
    return this.vmType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(cpu, that.cpu)) return false;
    if (!java.util.Objects.equals(memoryMB, that.memoryMB)) return false;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;
    if (!java.util.Objects.equals(vmType, that.vmType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cpu,  memoryMB,  osDisk,  vmType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cpu != null) { sb.append("cpu:"); sb.append(cpu + ","); }
    if (memoryMB != null) { sb.append("memoryMB:"); sb.append(memoryMB + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (vmType != null) { sb.append("vmType:"); sb.append(vmType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CpuNested<N> extends CPUFluent<CpuNested<N>> implements Nested<N>{
    CpuNested(CPU item) {
      this.builder = new CPUBuilder(this, item);
    }
    CPUBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withCpu(builder.build());
    }
    
    public N endCpu() {
      return and();
    }
    
  
  }
  public class OsDiskNested<N> extends DiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(Disk item) {
      this.builder = new DiskBuilder(this, item);
    }
    DiskBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withOsDisk(builder.build());
    }
    
    public N endOsDisk() {
      return and();
    }
    
  
  }

}