package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.PodSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterProvisionSpecFluent<A extends ClusterProvisionSpecFluent<A>> extends BaseFluent<A>{
  public ClusterProvisionSpecFluent() {
  }
  
  public ClusterProvisionSpecFluent(ClusterProvisionSpec instance) {
    this.copyInstance(instance);
  }
  private LocalObjectReferenceBuilder adminKubeconfigSecretRef;
  private LocalObjectReferenceBuilder adminPasswordSecretRef;
  private Integer attempt;
  private LocalObjectReferenceBuilder clusterDeploymentRef;
  private String clusterID;
  private String infraID;
  private String installLog;
  private Map<String,Object> metadata;
  private String metadataJSON;
  private PodSpec podSpec;
  private String prevClusterID;
  private String prevInfraID;
  private String prevProvisionName;
  private String stage;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterProvisionSpec instance) {
    instance = (instance != null ? instance : new ClusterProvisionSpec());
    if (instance != null) {
          this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
          this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
          this.withAttempt(instance.getAttempt());
          this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
          this.withClusterID(instance.getClusterID());
          this.withInfraID(instance.getInfraID());
          this.withInstallLog(instance.getInstallLog());
          this.withMetadata(instance.getMetadata());
          this.withMetadataJSON(instance.getMetadataJSON());
          this.withPodSpec(instance.getPodSpec());
          this.withPrevClusterID(instance.getPrevClusterID());
          this.withPrevInfraID(instance.getPrevInfraID());
          this.withPrevProvisionName(instance.getPrevProvisionName());
          this.withStage(instance.getStage());
          this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
          this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
          this.withAttempt(instance.getAttempt());
          this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
          this.withClusterID(instance.getClusterID());
          this.withInfraID(instance.getInfraID());
          this.withInstallLog(instance.getInstallLog());
          this.withMetadata(instance.getMetadata());
          this.withMetadataJSON(instance.getMetadataJSON());
          this.withPodSpec(instance.getPodSpec());
          this.withPrevClusterID(instance.getPrevClusterID());
          this.withPrevInfraID(instance.getPrevInfraID());
          this.withPrevProvisionName(instance.getPrevProvisionName());
          this.withStage(instance.getStage());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LocalObjectReference buildAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef != null ? this.adminKubeconfigSecretRef.build() : null;
  }
  
  public A withAdminKubeconfigSecretRef(LocalObjectReference adminKubeconfigSecretRef) {
    this._visitables.remove(this.adminKubeconfigSecretRef);
    if (adminKubeconfigSecretRef != null) {
        this.adminKubeconfigSecretRef = new LocalObjectReferenceBuilder(adminKubeconfigSecretRef);
        this._visitables.get("adminKubeconfigSecretRef").add(this.adminKubeconfigSecretRef);
    } else {
        this.adminKubeconfigSecretRef = null;
        this._visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef != null;
  }
  
  public A withNewAdminKubeconfigSecretRef(String name) {
    return (A)withAdminKubeconfigSecretRef(new LocalObjectReference(name));
  }
  
  public AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRef() {
    return new AdminKubeconfigSecretRefNested(null);
  }
  
  public AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return new AdminKubeconfigSecretRefNested(item);
  }
  
  public AdminKubeconfigSecretRefNested<A> editAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildAdminKubeconfigSecretRef()).orElse(null));
  }
  
  public AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildAdminKubeconfigSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return withNewAdminKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildAdminKubeconfigSecretRef()).orElse(item));
  }
  
  public LocalObjectReference buildAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef != null ? this.adminPasswordSecretRef.build() : null;
  }
  
  public A withAdminPasswordSecretRef(LocalObjectReference adminPasswordSecretRef) {
    this._visitables.remove(this.adminPasswordSecretRef);
    if (adminPasswordSecretRef != null) {
        this.adminPasswordSecretRef = new LocalObjectReferenceBuilder(adminPasswordSecretRef);
        this._visitables.get("adminPasswordSecretRef").add(this.adminPasswordSecretRef);
    } else {
        this.adminPasswordSecretRef = null;
        this._visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef != null;
  }
  
  public A withNewAdminPasswordSecretRef(String name) {
    return (A)withAdminPasswordSecretRef(new LocalObjectReference(name));
  }
  
  public AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRef() {
    return new AdminPasswordSecretRefNested(null);
  }
  
  public AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return new AdminPasswordSecretRefNested(item);
  }
  
  public AdminPasswordSecretRefNested<A> editAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(java.util.Optional.ofNullable(buildAdminPasswordSecretRef()).orElse(null));
  }
  
  public AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(java.util.Optional.ofNullable(buildAdminPasswordSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return withNewAdminPasswordSecretRefLike(java.util.Optional.ofNullable(buildAdminPasswordSecretRef()).orElse(item));
  }
  
  public Integer getAttempt() {
    return this.attempt;
  }
  
  public A withAttempt(Integer attempt) {
    this.attempt = attempt;
    return (A) this;
  }
  
  public boolean hasAttempt() {
    return this.attempt != null;
  }
  
  public LocalObjectReference buildClusterDeploymentRef() {
    return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
  }
  
  public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
    this._visitables.remove(this.clusterDeploymentRef);
    if (clusterDeploymentRef != null) {
        this.clusterDeploymentRef = new LocalObjectReferenceBuilder(clusterDeploymentRef);
        this._visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);
    } else {
        this.clusterDeploymentRef = null;
        this._visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterDeploymentRef() {
    return this.clusterDeploymentRef != null;
  }
  
  public A withNewClusterDeploymentRef(String name) {
    return (A)withClusterDeploymentRef(new LocalObjectReference(name));
  }
  
  public ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
    return new ClusterDeploymentRefNested(null);
  }
  
  public ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new ClusterDeploymentRefNested(item);
  }
  
  public ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(null));
  }
  
  public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(item));
  }
  
  public String getClusterID() {
    return this.clusterID;
  }
  
  public A withClusterID(String clusterID) {
    this.clusterID = clusterID;
    return (A) this;
  }
  
  public boolean hasClusterID() {
    return this.clusterID != null;
  }
  
  public String getInfraID() {
    return this.infraID;
  }
  
  public A withInfraID(String infraID) {
    this.infraID = infraID;
    return (A) this;
  }
  
  public boolean hasInfraID() {
    return this.infraID != null;
  }
  
  public String getInstallLog() {
    return this.installLog;
  }
  
  public A withInstallLog(String installLog) {
    this.installLog = installLog;
    return (A) this;
  }
  
  public boolean hasInstallLog() {
    return this.installLog != null;
  }
  
  public A addToMetadata(String key,Object value) {
    if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
  }
  
  public A addToMetadata(Map<String,Object> map) {
    if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap(); }
    if(map != null) { this.metadata.putAll(map);} return (A)this;
  }
  
  public A removeFromMetadata(String key) {
    if(this.metadata == null) { return (A) this; }
    if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
  }
  
  public A removeFromMetadata(Map<String,Object> map) {
    if(this.metadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getMetadata() {
    return this.metadata;
  }
  
  public <K,V>A withMetadata(Map<String,Object> metadata) {
    if (metadata == null) {
      this.metadata = null;
    } else {
      this.metadata = new LinkedHashMap(metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public String getMetadataJSON() {
    return this.metadataJSON;
  }
  
  public A withMetadataJSON(String metadataJSON) {
    this.metadataJSON = metadataJSON;
    return (A) this;
  }
  
  public boolean hasMetadataJSON() {
    return this.metadataJSON != null;
  }
  
  public PodSpec getPodSpec() {
    return this.podSpec;
  }
  
  public A withPodSpec(PodSpec podSpec) {
    this.podSpec = podSpec;
    return (A) this;
  }
  
  public boolean hasPodSpec() {
    return this.podSpec != null;
  }
  
  public String getPrevClusterID() {
    return this.prevClusterID;
  }
  
  public A withPrevClusterID(String prevClusterID) {
    this.prevClusterID = prevClusterID;
    return (A) this;
  }
  
  public boolean hasPrevClusterID() {
    return this.prevClusterID != null;
  }
  
  public String getPrevInfraID() {
    return this.prevInfraID;
  }
  
  public A withPrevInfraID(String prevInfraID) {
    this.prevInfraID = prevInfraID;
    return (A) this;
  }
  
  public boolean hasPrevInfraID() {
    return this.prevInfraID != null;
  }
  
  public String getPrevProvisionName() {
    return this.prevProvisionName;
  }
  
  public A withPrevProvisionName(String prevProvisionName) {
    this.prevProvisionName = prevProvisionName;
    return (A) this;
  }
  
  public boolean hasPrevProvisionName() {
    return this.prevProvisionName != null;
  }
  
  public String getStage() {
    return this.stage;
  }
  
  public A withStage(String stage) {
    this.stage = stage;
    return (A) this;
  }
  
  public boolean hasStage() {
    return this.stage != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterProvisionSpecFluent that = (ClusterProvisionSpecFluent) o;
    if (!java.util.Objects.equals(adminKubeconfigSecretRef, that.adminKubeconfigSecretRef)) return false;
    if (!java.util.Objects.equals(adminPasswordSecretRef, that.adminPasswordSecretRef)) return false;
    if (!java.util.Objects.equals(attempt, that.attempt)) return false;
    if (!java.util.Objects.equals(clusterDeploymentRef, that.clusterDeploymentRef)) return false;
    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;
    if (!java.util.Objects.equals(infraID, that.infraID)) return false;
    if (!java.util.Objects.equals(installLog, that.installLog)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(metadataJSON, that.metadataJSON)) return false;
    if (!java.util.Objects.equals(podSpec, that.podSpec)) return false;
    if (!java.util.Objects.equals(prevClusterID, that.prevClusterID)) return false;
    if (!java.util.Objects.equals(prevInfraID, that.prevInfraID)) return false;
    if (!java.util.Objects.equals(prevProvisionName, that.prevProvisionName)) return false;
    if (!java.util.Objects.equals(stage, that.stage)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(adminKubeconfigSecretRef,  adminPasswordSecretRef,  attempt,  clusterDeploymentRef,  clusterID,  infraID,  installLog,  metadata,  metadataJSON,  podSpec,  prevClusterID,  prevInfraID,  prevProvisionName,  stage,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (adminKubeconfigSecretRef != null) { sb.append("adminKubeconfigSecretRef:"); sb.append(adminKubeconfigSecretRef + ","); }
    if (adminPasswordSecretRef != null) { sb.append("adminPasswordSecretRef:"); sb.append(adminPasswordSecretRef + ","); }
    if (attempt != null) { sb.append("attempt:"); sb.append(attempt + ","); }
    if (clusterDeploymentRef != null) { sb.append("clusterDeploymentRef:"); sb.append(clusterDeploymentRef + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (infraID != null) { sb.append("infraID:"); sb.append(infraID + ","); }
    if (installLog != null) { sb.append("installLog:"); sb.append(installLog + ","); }
    if (metadata != null && !metadata.isEmpty()) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (metadataJSON != null) { sb.append("metadataJSON:"); sb.append(metadataJSON + ","); }
    if (podSpec != null) { sb.append("podSpec:"); sb.append(podSpec + ","); }
    if (prevClusterID != null) { sb.append("prevClusterID:"); sb.append(prevClusterID + ","); }
    if (prevInfraID != null) { sb.append("prevInfraID:"); sb.append(prevInfraID + ","); }
    if (prevProvisionName != null) { sb.append("prevProvisionName:"); sb.append(prevProvisionName + ","); }
    if (stage != null) { sb.append("stage:"); sb.append(stage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AdminKubeconfigSecretRefNested<N> extends LocalObjectReferenceFluent<AdminKubeconfigSecretRefNested<N>> implements Nested<N>{
    AdminKubeconfigSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterProvisionSpecFluent.this.withAdminKubeconfigSecretRef(builder.build());
    }
    
    public N endAdminKubeconfigSecretRef() {
      return and();
    }
    
  
  }
  public class AdminPasswordSecretRefNested<N> extends LocalObjectReferenceFluent<AdminPasswordSecretRefNested<N>> implements Nested<N>{
    AdminPasswordSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterProvisionSpecFluent.this.withAdminPasswordSecretRef(builder.build());
    }
    
    public N endAdminPasswordSecretRef() {
      return and();
    }
    
  
  }
  public class ClusterDeploymentRefNested<N> extends LocalObjectReferenceFluent<ClusterDeploymentRefNested<N>> implements Nested<N>{
    ClusterDeploymentRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterProvisionSpecFluent.this.withClusterDeploymentRef(builder.build());
    }
    
    public N endClusterDeploymentRef() {
      return and();
    }
    
  
  }

}