package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ControlPlaneConfigSpecFluent<A extends ControlPlaneConfigSpecFluent<A>> extends BaseFluent<A>{
  public ControlPlaneConfigSpecFluent() {
  }
  
  public ControlPlaneConfigSpecFluent(ControlPlaneConfigSpec instance) {
    this.copyInstance(instance);
  }
  private String apiServerIPOverride;
  private String apiURLOverride;
  private ControlPlaneServingCertificateSpecBuilder servingCertificates;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ControlPlaneConfigSpec instance) {
    instance = (instance != null ? instance : new ControlPlaneConfigSpec());
    if (instance != null) {
          this.withApiServerIPOverride(instance.getApiServerIPOverride());
          this.withApiURLOverride(instance.getApiURLOverride());
          this.withServingCertificates(instance.getServingCertificates());
          this.withApiServerIPOverride(instance.getApiServerIPOverride());
          this.withApiURLOverride(instance.getApiURLOverride());
          this.withServingCertificates(instance.getServingCertificates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiServerIPOverride() {
    return this.apiServerIPOverride;
  }
  
  public A withApiServerIPOverride(String apiServerIPOverride) {
    this.apiServerIPOverride = apiServerIPOverride;
    return (A) this;
  }
  
  public boolean hasApiServerIPOverride() {
    return this.apiServerIPOverride != null;
  }
  
  public String getApiURLOverride() {
    return this.apiURLOverride;
  }
  
  public A withApiURLOverride(String apiURLOverride) {
    this.apiURLOverride = apiURLOverride;
    return (A) this;
  }
  
  public boolean hasApiURLOverride() {
    return this.apiURLOverride != null;
  }
  
  public ControlPlaneServingCertificateSpec buildServingCertificates() {
    return this.servingCertificates != null ? this.servingCertificates.build() : null;
  }
  
  public A withServingCertificates(ControlPlaneServingCertificateSpec servingCertificates) {
    this._visitables.remove(this.servingCertificates);
    if (servingCertificates != null) {
        this.servingCertificates = new ControlPlaneServingCertificateSpecBuilder(servingCertificates);
        this._visitables.get("servingCertificates").add(this.servingCertificates);
    } else {
        this.servingCertificates = null;
        this._visitables.get("servingCertificates").remove(this.servingCertificates);
    }
    return (A) this;
  }
  
  public boolean hasServingCertificates() {
    return this.servingCertificates != null;
  }
  
  public ServingCertificatesNested<A> withNewServingCertificates() {
    return new ServingCertificatesNested(null);
  }
  
  public ServingCertificatesNested<A> withNewServingCertificatesLike(ControlPlaneServingCertificateSpec item) {
    return new ServingCertificatesNested(item);
  }
  
  public ServingCertificatesNested<A> editServingCertificates() {
    return withNewServingCertificatesLike(java.util.Optional.ofNullable(buildServingCertificates()).orElse(null));
  }
  
  public ServingCertificatesNested<A> editOrNewServingCertificates() {
    return withNewServingCertificatesLike(java.util.Optional.ofNullable(buildServingCertificates()).orElse(new ControlPlaneServingCertificateSpecBuilder().build()));
  }
  
  public ServingCertificatesNested<A> editOrNewServingCertificatesLike(ControlPlaneServingCertificateSpec item) {
    return withNewServingCertificatesLike(java.util.Optional.ofNullable(buildServingCertificates()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControlPlaneConfigSpecFluent that = (ControlPlaneConfigSpecFluent) o;
    if (!java.util.Objects.equals(apiServerIPOverride, that.apiServerIPOverride)) return false;
    if (!java.util.Objects.equals(apiURLOverride, that.apiURLOverride)) return false;
    if (!java.util.Objects.equals(servingCertificates, that.servingCertificates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiServerIPOverride,  apiURLOverride,  servingCertificates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiServerIPOverride != null) { sb.append("apiServerIPOverride:"); sb.append(apiServerIPOverride + ","); }
    if (apiURLOverride != null) { sb.append("apiURLOverride:"); sb.append(apiURLOverride + ","); }
    if (servingCertificates != null) { sb.append("servingCertificates:"); sb.append(servingCertificates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServingCertificatesNested<N> extends ControlPlaneServingCertificateSpecFluent<ServingCertificatesNested<N>> implements Nested<N>{
    ServingCertificatesNested(ControlPlaneServingCertificateSpec item) {
      this.builder = new ControlPlaneServingCertificateSpecBuilder(this, item);
    }
    ControlPlaneServingCertificateSpecBuilder builder;
    
    public N and() {
      return (N) ControlPlaneConfigSpecFluent.this.withServingCertificates(builder.build());
    }
    
    public N endServingCertificates() {
      return and();
    }
    
  
  }

}