package io.fabric8.openshift.api.model.hive.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ControllerConfigFluent<A extends ControllerConfigFluent<A>> extends BaseFluent<A>{
  public ControllerConfigFluent() {
  }
  
  public ControllerConfigFluent(ControllerConfig instance) {
    this.copyInstance(instance);
  }
  private Integer clientBurst;
  private Integer clientQPS;
  private Integer concurrentReconciles;
  private Integer queueBurst;
  private Integer queueQPS;
  private Integer replicas;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ControllerConfig instance) {
    instance = (instance != null ? instance : new ControllerConfig());
    if (instance != null) {
          this.withClientBurst(instance.getClientBurst());
          this.withClientQPS(instance.getClientQPS());
          this.withConcurrentReconciles(instance.getConcurrentReconciles());
          this.withQueueBurst(instance.getQueueBurst());
          this.withQueueQPS(instance.getQueueQPS());
          this.withReplicas(instance.getReplicas());
          this.withClientBurst(instance.getClientBurst());
          this.withClientQPS(instance.getClientQPS());
          this.withConcurrentReconciles(instance.getConcurrentReconciles());
          this.withQueueBurst(instance.getQueueBurst());
          this.withQueueQPS(instance.getQueueQPS());
          this.withReplicas(instance.getReplicas());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getClientBurst() {
    return this.clientBurst;
  }
  
  public A withClientBurst(Integer clientBurst) {
    this.clientBurst = clientBurst;
    return (A) this;
  }
  
  public boolean hasClientBurst() {
    return this.clientBurst != null;
  }
  
  public Integer getClientQPS() {
    return this.clientQPS;
  }
  
  public A withClientQPS(Integer clientQPS) {
    this.clientQPS = clientQPS;
    return (A) this;
  }
  
  public boolean hasClientQPS() {
    return this.clientQPS != null;
  }
  
  public Integer getConcurrentReconciles() {
    return this.concurrentReconciles;
  }
  
  public A withConcurrentReconciles(Integer concurrentReconciles) {
    this.concurrentReconciles = concurrentReconciles;
    return (A) this;
  }
  
  public boolean hasConcurrentReconciles() {
    return this.concurrentReconciles != null;
  }
  
  public Integer getQueueBurst() {
    return this.queueBurst;
  }
  
  public A withQueueBurst(Integer queueBurst) {
    this.queueBurst = queueBurst;
    return (A) this;
  }
  
  public boolean hasQueueBurst() {
    return this.queueBurst != null;
  }
  
  public Integer getQueueQPS() {
    return this.queueQPS;
  }
  
  public A withQueueQPS(Integer queueQPS) {
    this.queueQPS = queueQPS;
    return (A) this;
  }
  
  public boolean hasQueueQPS() {
    return this.queueQPS != null;
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControllerConfigFluent that = (ControllerConfigFluent) o;
    if (!java.util.Objects.equals(clientBurst, that.clientBurst)) return false;
    if (!java.util.Objects.equals(clientQPS, that.clientQPS)) return false;
    if (!java.util.Objects.equals(concurrentReconciles, that.concurrentReconciles)) return false;
    if (!java.util.Objects.equals(queueBurst, that.queueBurst)) return false;
    if (!java.util.Objects.equals(queueQPS, that.queueQPS)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientBurst,  clientQPS,  concurrentReconciles,  queueBurst,  queueQPS,  replicas,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientBurst != null) { sb.append("clientBurst:"); sb.append(clientBurst + ","); }
    if (clientQPS != null) { sb.append("clientQPS:"); sb.append(clientQPS + ","); }
    if (concurrentReconciles != null) { sb.append("concurrentReconciles:"); sb.append(concurrentReconciles + ","); }
    if (queueBurst != null) { sb.append("queueBurst:"); sb.append(queueBurst + ","); }
    if (queueQPS != null) { sb.append("queueQPS:"); sb.append(queueQPS + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}