package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.Taint;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolSpecFluent<A extends MachinePoolSpecFluent<A>> extends BaseFluent<A>{
  public MachinePoolSpecFluent() {
  }
  
  public MachinePoolSpecFluent(MachinePoolSpec instance) {
    this.copyInstance(instance);
  }
  private MachinePoolAutoscalingBuilder autoscaling;
  private LocalObjectReferenceBuilder clusterDeploymentRef;
  private Map<String,String> labels;
  private String name;
  private MachinePoolPlatformBuilder platform;
  private Long replicas;
  private List<Taint> taints = new ArrayList<Taint>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePoolSpec instance) {
    instance = (instance != null ? instance : new MachinePoolSpec());
    if (instance != null) {
          this.withAutoscaling(instance.getAutoscaling());
          this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
          this.withLabels(instance.getLabels());
          this.withName(instance.getName());
          this.withPlatform(instance.getPlatform());
          this.withReplicas(instance.getReplicas());
          this.withTaints(instance.getTaints());
          this.withAutoscaling(instance.getAutoscaling());
          this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
          this.withLabels(instance.getLabels());
          this.withName(instance.getName());
          this.withPlatform(instance.getPlatform());
          this.withReplicas(instance.getReplicas());
          this.withTaints(instance.getTaints());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public MachinePoolAutoscaling buildAutoscaling() {
    return this.autoscaling != null ? this.autoscaling.build() : null;
  }
  
  public A withAutoscaling(MachinePoolAutoscaling autoscaling) {
    this._visitables.remove(this.autoscaling);
    if (autoscaling != null) {
        this.autoscaling = new MachinePoolAutoscalingBuilder(autoscaling);
        this._visitables.get("autoscaling").add(this.autoscaling);
    } else {
        this.autoscaling = null;
        this._visitables.get("autoscaling").remove(this.autoscaling);
    }
    return (A) this;
  }
  
  public boolean hasAutoscaling() {
    return this.autoscaling != null;
  }
  
  public A withNewAutoscaling(Integer maxReplicas,Integer minReplicas) {
    return (A)withAutoscaling(new MachinePoolAutoscaling(maxReplicas, minReplicas));
  }
  
  public AutoscalingNested<A> withNewAutoscaling() {
    return new AutoscalingNested(null);
  }
  
  public AutoscalingNested<A> withNewAutoscalingLike(MachinePoolAutoscaling item) {
    return new AutoscalingNested(item);
  }
  
  public AutoscalingNested<A> editAutoscaling() {
    return withNewAutoscalingLike(java.util.Optional.ofNullable(buildAutoscaling()).orElse(null));
  }
  
  public AutoscalingNested<A> editOrNewAutoscaling() {
    return withNewAutoscalingLike(java.util.Optional.ofNullable(buildAutoscaling()).orElse(new MachinePoolAutoscalingBuilder().build()));
  }
  
  public AutoscalingNested<A> editOrNewAutoscalingLike(MachinePoolAutoscaling item) {
    return withNewAutoscalingLike(java.util.Optional.ofNullable(buildAutoscaling()).orElse(item));
  }
  
  public LocalObjectReference buildClusterDeploymentRef() {
    return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
  }
  
  public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
    this._visitables.remove(this.clusterDeploymentRef);
    if (clusterDeploymentRef != null) {
        this.clusterDeploymentRef = new LocalObjectReferenceBuilder(clusterDeploymentRef);
        this._visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);
    } else {
        this.clusterDeploymentRef = null;
        this._visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterDeploymentRef() {
    return this.clusterDeploymentRef != null;
  }
  
  public A withNewClusterDeploymentRef(String name) {
    return (A)withClusterDeploymentRef(new LocalObjectReference(name));
  }
  
  public ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
    return new ClusterDeploymentRefNested(null);
  }
  
  public ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new ClusterDeploymentRefNested(item);
  }
  
  public ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(null));
  }
  
  public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(item));
  }
  
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getLabels() {
    return this.labels;
  }
  
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) {
      this.labels = null;
    } else {
      this.labels = new LinkedHashMap(labels);
    }
    return (A) this;
  }
  
  public boolean hasLabels() {
    return this.labels != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public MachinePoolPlatform buildPlatform() {
    return this.platform != null ? this.platform.build() : null;
  }
  
  public A withPlatform(MachinePoolPlatform platform) {
    this._visitables.remove(this.platform);
    if (platform != null) {
        this.platform = new MachinePoolPlatformBuilder(platform);
        this._visitables.get("platform").add(this.platform);
    } else {
        this.platform = null;
        this._visitables.get("platform").remove(this.platform);
    }
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new MachinePoolPlatformBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public Long getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Long replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public A addToTaints(int index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.add(index, item);
    return (A)this;
  }
  
  public A setToTaints(int index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.set(index, item); return (A)this;
  }
  
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  
  public A addAllToTaints(Collection<Taint> items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) return (A)this;
    for (Taint item : items) { this.taints.remove(item);} return (A)this;
  }
  
  public A removeAllFromTaints(Collection<Taint> items) {
    if (this.taints == null) return (A)this;
    for (Taint item : items) { this.taints.remove(item);} return (A)this;
  }
  
  public List<Taint> getTaints() {
    return this.taints;
  }
  
  public Taint getTaint(int index) {
    return this.taints.get(index);
  }
  
  public Taint getFirstTaint() {
    return this.taints.get(0);
  }
  
  public Taint getLastTaint() {
    return this.taints.get(taints.size() - 1);
  }
  
  public Taint getMatchingTaint(Predicate<Taint> predicate) {
      for (Taint item : taints) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTaint(Predicate<Taint> predicate) {
      for (Taint item : taints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTaints(List<Taint> taints) {
    if (taints != null) {
        this.taints = new ArrayList();
        for (Taint item : taints) {
          this.addToTaints(item);
        }
    } else {
      this.taints = null;
    }
    return (A) this;
  }
  
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear(); _visitables.remove("taints"); }
    if (taints != null) {for (Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  
  public boolean hasTaints() {
    return this.taints != null && !this.taints.isEmpty();
  }
  
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolSpecFluent that = (MachinePoolSpecFluent) o;
    if (!java.util.Objects.equals(autoscaling, that.autoscaling)) return false;
    if (!java.util.Objects.equals(clusterDeploymentRef, that.clusterDeploymentRef)) return false;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(taints, that.taints)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(autoscaling,  clusterDeploymentRef,  labels,  name,  platform,  replicas,  taints,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoscaling != null) { sb.append("autoscaling:"); sb.append(autoscaling + ","); }
    if (clusterDeploymentRef != null) { sb.append("clusterDeploymentRef:"); sb.append(clusterDeploymentRef + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AutoscalingNested<N> extends MachinePoolAutoscalingFluent<AutoscalingNested<N>> implements Nested<N>{
    AutoscalingNested(MachinePoolAutoscaling item) {
      this.builder = new MachinePoolAutoscalingBuilder(this, item);
    }
    MachinePoolAutoscalingBuilder builder;
    
    public N and() {
      return (N) MachinePoolSpecFluent.this.withAutoscaling(builder.build());
    }
    
    public N endAutoscaling() {
      return and();
    }
    
  
  }
  public class ClusterDeploymentRefNested<N> extends LocalObjectReferenceFluent<ClusterDeploymentRefNested<N>> implements Nested<N>{
    ClusterDeploymentRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) MachinePoolSpecFluent.this.withClusterDeploymentRef(builder.build());
    }
    
    public N endClusterDeploymentRef() {
      return and();
    }
    
  
  }
  public class PlatformNested<N> extends MachinePoolPlatformFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(MachinePoolPlatform item) {
      this.builder = new MachinePoolPlatformBuilder(this, item);
    }
    MachinePoolPlatformBuilder builder;
    
    public N and() {
      return (N) MachinePoolSpecFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }

}