package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolStatusFluent<A extends MachinePoolStatusFluent<A>> extends BaseFluent<A>{
  public MachinePoolStatusFluent() {
  }
  
  public MachinePoolStatusFluent(MachinePoolStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<MachinePoolConditionBuilder> conditions = new ArrayList<MachinePoolConditionBuilder>();
  private ArrayList<MachineSetStatusBuilder> machineSets = new ArrayList<MachineSetStatusBuilder>();
  private List<String> ownedLabels = new ArrayList<String>();
  private ArrayList<TaintIdentifierBuilder> ownedTaints = new ArrayList<TaintIdentifierBuilder>();
  private Integer replicas;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePoolStatus instance) {
    instance = (instance != null ? instance : new MachinePoolStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withMachineSets(instance.getMachineSets());
          this.withOwnedLabels(instance.getOwnedLabels());
          this.withOwnedTaints(instance.getOwnedTaints());
          this.withReplicas(instance.getReplicas());
          this.withConditions(instance.getConditions());
          this.withMachineSets(instance.getMachineSets());
          this.withOwnedLabels(instance.getOwnedLabels());
          this.withOwnedTaints(instance.getOwnedTaints());
          this.withReplicas(instance.getReplicas());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,MachinePoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,MachinePoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.MachinePoolCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<MachinePoolCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.MachinePoolCondition... items) {
    if (this.conditions == null) return (A)this;
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<MachinePoolCondition> items) {
    if (this.conditions == null) return (A)this;
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<MachinePoolConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<MachinePoolConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      MachinePoolConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachinePoolCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public MachinePoolCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public MachinePoolCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public MachinePoolCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public MachinePoolCondition buildMatchingCondition(Predicate<MachinePoolConditionBuilder> predicate) {
      for (MachinePoolConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<MachinePoolConditionBuilder> predicate) {
      for (MachinePoolConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<MachinePoolCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (MachinePoolCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.MachinePoolCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (MachinePoolCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(MachinePoolCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,MachinePoolCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<MachinePoolConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToMachineSets(int index,MachineSetStatus item) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);
    if (index < 0 || index >= machineSets.size()) { _visitables.get("machineSets").add(builder); machineSets.add(builder); } else { _visitables.get("machineSets").add(index, builder); machineSets.add(index, builder);}
    return (A)this;
  }
  
  public A setToMachineSets(int index,MachineSetStatus item) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);
    if (index < 0 || index >= machineSets.size()) { _visitables.get("machineSets").add(builder); machineSets.add(builder); } else { _visitables.get("machineSets").set(index, builder); machineSets.set(index, builder);}
    return (A)this;
  }
  
  public A addToMachineSets(io.fabric8.openshift.api.model.hive.v1.MachineSetStatus... items) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").add(builder);this.machineSets.add(builder);} return (A)this;
  }
  
  public A addAllToMachineSets(Collection<MachineSetStatus> items) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").add(builder);this.machineSets.add(builder);} return (A)this;
  }
  
  public A removeFromMachineSets(io.fabric8.openshift.api.model.hive.v1.MachineSetStatus... items) {
    if (this.machineSets == null) return (A)this;
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").remove(builder); this.machineSets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMachineSets(Collection<MachineSetStatus> items) {
    if (this.machineSets == null) return (A)this;
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").remove(builder); this.machineSets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMachineSets(Predicate<MachineSetStatusBuilder> predicate) {
    if (machineSets == null) return (A) this;
    final Iterator<MachineSetStatusBuilder> each = machineSets.iterator();
    final List visitables = _visitables.get("machineSets");
    while (each.hasNext()) {
      MachineSetStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineSetStatus> buildMachineSets() {
    return this.machineSets != null ? build(machineSets) : null;
  }
  
  public MachineSetStatus buildMachineSet(int index) {
    return this.machineSets.get(index).build();
  }
  
  public MachineSetStatus buildFirstMachineSet() {
    return this.machineSets.get(0).build();
  }
  
  public MachineSetStatus buildLastMachineSet() {
    return this.machineSets.get(machineSets.size() - 1).build();
  }
  
  public MachineSetStatus buildMatchingMachineSet(Predicate<MachineSetStatusBuilder> predicate) {
      for (MachineSetStatusBuilder item : machineSets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMachineSet(Predicate<MachineSetStatusBuilder> predicate) {
      for (MachineSetStatusBuilder item : machineSets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMachineSets(List<MachineSetStatus> machineSets) {
    if (this.machineSets != null) {
      this._visitables.get("machineSets").clear();
    }
    if (machineSets != null) {
        this.machineSets = new ArrayList();
        for (MachineSetStatus item : machineSets) {
          this.addToMachineSets(item);
        }
    } else {
      this.machineSets = null;
    }
    return (A) this;
  }
  
  public A withMachineSets(io.fabric8.openshift.api.model.hive.v1.MachineSetStatus... machineSets) {
    if (this.machineSets != null) {this.machineSets.clear(); _visitables.remove("machineSets"); }
    if (machineSets != null) {for (MachineSetStatus item :machineSets){ this.addToMachineSets(item);}} return (A) this;
  }
  
  public boolean hasMachineSets() {
    return this.machineSets != null && !this.machineSets.isEmpty();
  }
  
  public MachineSetsNested<A> addNewMachineSet() {
    return new MachineSetsNested(-1, null);
  }
  
  public MachineSetsNested<A> addNewMachineSetLike(MachineSetStatus item) {
    return new MachineSetsNested(-1, item);
  }
  
  public MachineSetsNested<A> setNewMachineSetLike(int index,MachineSetStatus item) {
    return new MachineSetsNested(index, item);
  }
  
  public MachineSetsNested<A> editMachineSet(int index) {
    if (machineSets.size() <= index) throw new RuntimeException("Can't edit machineSets. Index exceeds size.");
    return setNewMachineSetLike(index, buildMachineSet(index));
  }
  
  public MachineSetsNested<A> editFirstMachineSet() {
    if (machineSets.size() == 0) throw new RuntimeException("Can't edit first machineSets. The list is empty.");
    return setNewMachineSetLike(0, buildMachineSet(0));
  }
  
  public MachineSetsNested<A> editLastMachineSet() {
    int index = machineSets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last machineSets. The list is empty.");
    return setNewMachineSetLike(index, buildMachineSet(index));
  }
  
  public MachineSetsNested<A> editMatchingMachineSet(Predicate<MachineSetStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<machineSets.size();i++) { 
    if (predicate.test(machineSets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching machineSets. No match found.");
    return setNewMachineSetLike(index, buildMachineSet(index));
  }
  
  public A addToOwnedLabels(int index,String item) {
    if (this.ownedLabels == null) {this.ownedLabels = new ArrayList<String>();}
    this.ownedLabels.add(index, item);
    return (A)this;
  }
  
  public A setToOwnedLabels(int index,String item) {
    if (this.ownedLabels == null) {this.ownedLabels = new ArrayList<String>();}
    this.ownedLabels.set(index, item); return (A)this;
  }
  
  public A addToOwnedLabels(java.lang.String... items) {
    if (this.ownedLabels == null) {this.ownedLabels = new ArrayList<String>();}
    for (String item : items) {this.ownedLabels.add(item);} return (A)this;
  }
  
  public A addAllToOwnedLabels(Collection<String> items) {
    if (this.ownedLabels == null) {this.ownedLabels = new ArrayList<String>();}
    for (String item : items) {this.ownedLabels.add(item);} return (A)this;
  }
  
  public A removeFromOwnedLabels(java.lang.String... items) {
    if (this.ownedLabels == null) return (A)this;
    for (String item : items) { this.ownedLabels.remove(item);} return (A)this;
  }
  
  public A removeAllFromOwnedLabels(Collection<String> items) {
    if (this.ownedLabels == null) return (A)this;
    for (String item : items) { this.ownedLabels.remove(item);} return (A)this;
  }
  
  public List<String> getOwnedLabels() {
    return this.ownedLabels;
  }
  
  public String getOwnedLabel(int index) {
    return this.ownedLabels.get(index);
  }
  
  public String getFirstOwnedLabel() {
    return this.ownedLabels.get(0);
  }
  
  public String getLastOwnedLabel() {
    return this.ownedLabels.get(ownedLabels.size() - 1);
  }
  
  public String getMatchingOwnedLabel(Predicate<String> predicate) {
      for (String item : ownedLabels) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingOwnedLabel(Predicate<String> predicate) {
      for (String item : ownedLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOwnedLabels(List<String> ownedLabels) {
    if (ownedLabels != null) {
        this.ownedLabels = new ArrayList();
        for (String item : ownedLabels) {
          this.addToOwnedLabels(item);
        }
    } else {
      this.ownedLabels = null;
    }
    return (A) this;
  }
  
  public A withOwnedLabels(java.lang.String... ownedLabels) {
    if (this.ownedLabels != null) {this.ownedLabels.clear(); _visitables.remove("ownedLabels"); }
    if (ownedLabels != null) {for (String item :ownedLabels){ this.addToOwnedLabels(item);}} return (A) this;
  }
  
  public boolean hasOwnedLabels() {
    return this.ownedLabels != null && !this.ownedLabels.isEmpty();
  }
  
  public A addToOwnedTaints(int index,TaintIdentifier item) {
    if (this.ownedTaints == null) {this.ownedTaints = new ArrayList<TaintIdentifierBuilder>();}
    TaintIdentifierBuilder builder = new TaintIdentifierBuilder(item);
    if (index < 0 || index >= ownedTaints.size()) { _visitables.get("ownedTaints").add(builder); ownedTaints.add(builder); } else { _visitables.get("ownedTaints").add(index, builder); ownedTaints.add(index, builder);}
    return (A)this;
  }
  
  public A setToOwnedTaints(int index,TaintIdentifier item) {
    if (this.ownedTaints == null) {this.ownedTaints = new ArrayList<TaintIdentifierBuilder>();}
    TaintIdentifierBuilder builder = new TaintIdentifierBuilder(item);
    if (index < 0 || index >= ownedTaints.size()) { _visitables.get("ownedTaints").add(builder); ownedTaints.add(builder); } else { _visitables.get("ownedTaints").set(index, builder); ownedTaints.set(index, builder);}
    return (A)this;
  }
  
  public A addToOwnedTaints(io.fabric8.openshift.api.model.hive.v1.TaintIdentifier... items) {
    if (this.ownedTaints == null) {this.ownedTaints = new ArrayList<TaintIdentifierBuilder>();}
    for (TaintIdentifier item : items) {TaintIdentifierBuilder builder = new TaintIdentifierBuilder(item);_visitables.get("ownedTaints").add(builder);this.ownedTaints.add(builder);} return (A)this;
  }
  
  public A addAllToOwnedTaints(Collection<TaintIdentifier> items) {
    if (this.ownedTaints == null) {this.ownedTaints = new ArrayList<TaintIdentifierBuilder>();}
    for (TaintIdentifier item : items) {TaintIdentifierBuilder builder = new TaintIdentifierBuilder(item);_visitables.get("ownedTaints").add(builder);this.ownedTaints.add(builder);} return (A)this;
  }
  
  public A removeFromOwnedTaints(io.fabric8.openshift.api.model.hive.v1.TaintIdentifier... items) {
    if (this.ownedTaints == null) return (A)this;
    for (TaintIdentifier item : items) {TaintIdentifierBuilder builder = new TaintIdentifierBuilder(item);_visitables.get("ownedTaints").remove(builder); this.ownedTaints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOwnedTaints(Collection<TaintIdentifier> items) {
    if (this.ownedTaints == null) return (A)this;
    for (TaintIdentifier item : items) {TaintIdentifierBuilder builder = new TaintIdentifierBuilder(item);_visitables.get("ownedTaints").remove(builder); this.ownedTaints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOwnedTaints(Predicate<TaintIdentifierBuilder> predicate) {
    if (ownedTaints == null) return (A) this;
    final Iterator<TaintIdentifierBuilder> each = ownedTaints.iterator();
    final List visitables = _visitables.get("ownedTaints");
    while (each.hasNext()) {
      TaintIdentifierBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TaintIdentifier> buildOwnedTaints() {
    return this.ownedTaints != null ? build(ownedTaints) : null;
  }
  
  public TaintIdentifier buildOwnedTaint(int index) {
    return this.ownedTaints.get(index).build();
  }
  
  public TaintIdentifier buildFirstOwnedTaint() {
    return this.ownedTaints.get(0).build();
  }
  
  public TaintIdentifier buildLastOwnedTaint() {
    return this.ownedTaints.get(ownedTaints.size() - 1).build();
  }
  
  public TaintIdentifier buildMatchingOwnedTaint(Predicate<TaintIdentifierBuilder> predicate) {
      for (TaintIdentifierBuilder item : ownedTaints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOwnedTaint(Predicate<TaintIdentifierBuilder> predicate) {
      for (TaintIdentifierBuilder item : ownedTaints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOwnedTaints(List<TaintIdentifier> ownedTaints) {
    if (this.ownedTaints != null) {
      this._visitables.get("ownedTaints").clear();
    }
    if (ownedTaints != null) {
        this.ownedTaints = new ArrayList();
        for (TaintIdentifier item : ownedTaints) {
          this.addToOwnedTaints(item);
        }
    } else {
      this.ownedTaints = null;
    }
    return (A) this;
  }
  
  public A withOwnedTaints(io.fabric8.openshift.api.model.hive.v1.TaintIdentifier... ownedTaints) {
    if (this.ownedTaints != null) {this.ownedTaints.clear(); _visitables.remove("ownedTaints"); }
    if (ownedTaints != null) {for (TaintIdentifier item :ownedTaints){ this.addToOwnedTaints(item);}} return (A) this;
  }
  
  public boolean hasOwnedTaints() {
    return this.ownedTaints != null && !this.ownedTaints.isEmpty();
  }
  
  public A addNewOwnedTaint(String effect,String key) {
    return (A)addToOwnedTaints(new TaintIdentifier(effect, key));
  }
  
  public OwnedTaintsNested<A> addNewOwnedTaint() {
    return new OwnedTaintsNested(-1, null);
  }
  
  public OwnedTaintsNested<A> addNewOwnedTaintLike(TaintIdentifier item) {
    return new OwnedTaintsNested(-1, item);
  }
  
  public OwnedTaintsNested<A> setNewOwnedTaintLike(int index,TaintIdentifier item) {
    return new OwnedTaintsNested(index, item);
  }
  
  public OwnedTaintsNested<A> editOwnedTaint(int index) {
    if (ownedTaints.size() <= index) throw new RuntimeException("Can't edit ownedTaints. Index exceeds size.");
    return setNewOwnedTaintLike(index, buildOwnedTaint(index));
  }
  
  public OwnedTaintsNested<A> editFirstOwnedTaint() {
    if (ownedTaints.size() == 0) throw new RuntimeException("Can't edit first ownedTaints. The list is empty.");
    return setNewOwnedTaintLike(0, buildOwnedTaint(0));
  }
  
  public OwnedTaintsNested<A> editLastOwnedTaint() {
    int index = ownedTaints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ownedTaints. The list is empty.");
    return setNewOwnedTaintLike(index, buildOwnedTaint(index));
  }
  
  public OwnedTaintsNested<A> editMatchingOwnedTaint(Predicate<TaintIdentifierBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ownedTaints.size();i++) { 
    if (predicate.test(ownedTaints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ownedTaints. No match found.");
    return setNewOwnedTaintLike(index, buildOwnedTaint(index));
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolStatusFluent that = (MachinePoolStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(machineSets, that.machineSets)) return false;
    if (!java.util.Objects.equals(ownedLabels, that.ownedLabels)) return false;
    if (!java.util.Objects.equals(ownedTaints, that.ownedTaints)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  machineSets,  ownedLabels,  ownedTaints,  replicas,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (machineSets != null && !machineSets.isEmpty()) { sb.append("machineSets:"); sb.append(machineSets + ","); }
    if (ownedLabels != null && !ownedLabels.isEmpty()) { sb.append("ownedLabels:"); sb.append(ownedLabels + ","); }
    if (ownedTaints != null && !ownedTaints.isEmpty()) { sb.append("ownedTaints:"); sb.append(ownedTaints + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends MachinePoolConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,MachinePoolCondition item) {
      this.index = index;
      this.builder = new MachinePoolConditionBuilder(this, item);
    }
    MachinePoolConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) MachinePoolStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class MachineSetsNested<N> extends MachineSetStatusFluent<MachineSetsNested<N>> implements Nested<N>{
    MachineSetsNested(int index,MachineSetStatus item) {
      this.index = index;
      this.builder = new MachineSetStatusBuilder(this, item);
    }
    MachineSetStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) MachinePoolStatusFluent.this.setToMachineSets(index,builder.build());
    }
    
    public N endMachineSet() {
      return and();
    }
    
  
  }
  public class OwnedTaintsNested<N> extends TaintIdentifierFluent<OwnedTaintsNested<N>> implements Nested<N>{
    OwnedTaintsNested(int index,TaintIdentifier item) {
      this.index = index;
      this.builder = new TaintIdentifierBuilder(this, item);
    }
    TaintIdentifierBuilder builder;
    int index;
    
    public N and() {
      return (N) MachinePoolStatusFluent.this.setToOwnedTaints(index,builder.build());
    }
    
    public N endOwnedTaint() {
      return and();
    }
    
  
  }

}