package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SecretMappingFluent<A extends SecretMappingFluent<A>> extends BaseFluent<A>{
  public SecretMappingFluent() {
  }
  
  public SecretMappingFluent(SecretMapping instance) {
    this.copyInstance(instance);
  }
  private SecretReferenceBuilder sourceRef;
  private SecretReferenceBuilder targetRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SecretMapping instance) {
    instance = (instance != null ? instance : new SecretMapping());
    if (instance != null) {
          this.withSourceRef(instance.getSourceRef());
          this.withTargetRef(instance.getTargetRef());
          this.withSourceRef(instance.getSourceRef());
          this.withTargetRef(instance.getTargetRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretReference buildSourceRef() {
    return this.sourceRef != null ? this.sourceRef.build() : null;
  }
  
  public A withSourceRef(SecretReference sourceRef) {
    this._visitables.remove(this.sourceRef);
    if (sourceRef != null) {
        this.sourceRef = new SecretReferenceBuilder(sourceRef);
        this._visitables.get("sourceRef").add(this.sourceRef);
    } else {
        this.sourceRef = null;
        this._visitables.get("sourceRef").remove(this.sourceRef);
    }
    return (A) this;
  }
  
  public boolean hasSourceRef() {
    return this.sourceRef != null;
  }
  
  public A withNewSourceRef(String name,String namespace) {
    return (A)withSourceRef(new SecretReference(name, namespace));
  }
  
  public SourceRefNested<A> withNewSourceRef() {
    return new SourceRefNested(null);
  }
  
  public SourceRefNested<A> withNewSourceRefLike(SecretReference item) {
    return new SourceRefNested(item);
  }
  
  public SourceRefNested<A> editSourceRef() {
    return withNewSourceRefLike(java.util.Optional.ofNullable(buildSourceRef()).orElse(null));
  }
  
  public SourceRefNested<A> editOrNewSourceRef() {
    return withNewSourceRefLike(java.util.Optional.ofNullable(buildSourceRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public SourceRefNested<A> editOrNewSourceRefLike(SecretReference item) {
    return withNewSourceRefLike(java.util.Optional.ofNullable(buildSourceRef()).orElse(item));
  }
  
  public SecretReference buildTargetRef() {
    return this.targetRef != null ? this.targetRef.build() : null;
  }
  
  public A withTargetRef(SecretReference targetRef) {
    this._visitables.remove(this.targetRef);
    if (targetRef != null) {
        this.targetRef = new SecretReferenceBuilder(targetRef);
        this._visitables.get("targetRef").add(this.targetRef);
    } else {
        this.targetRef = null;
        this._visitables.get("targetRef").remove(this.targetRef);
    }
    return (A) this;
  }
  
  public boolean hasTargetRef() {
    return this.targetRef != null;
  }
  
  public A withNewTargetRef(String name,String namespace) {
    return (A)withTargetRef(new SecretReference(name, namespace));
  }
  
  public TargetRefNested<A> withNewTargetRef() {
    return new TargetRefNested(null);
  }
  
  public TargetRefNested<A> withNewTargetRefLike(SecretReference item) {
    return new TargetRefNested(item);
  }
  
  public TargetRefNested<A> editTargetRef() {
    return withNewTargetRefLike(java.util.Optional.ofNullable(buildTargetRef()).orElse(null));
  }
  
  public TargetRefNested<A> editOrNewTargetRef() {
    return withNewTargetRefLike(java.util.Optional.ofNullable(buildTargetRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public TargetRefNested<A> editOrNewTargetRefLike(SecretReference item) {
    return withNewTargetRefLike(java.util.Optional.ofNullable(buildTargetRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretMappingFluent that = (SecretMappingFluent) o;
    if (!java.util.Objects.equals(sourceRef, that.sourceRef)) return false;
    if (!java.util.Objects.equals(targetRef, that.targetRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sourceRef,  targetRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sourceRef != null) { sb.append("sourceRef:"); sb.append(sourceRef + ","); }
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SourceRefNested<N> extends SecretReferenceFluent<SourceRefNested<N>> implements Nested<N>{
    SourceRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) SecretMappingFluent.this.withSourceRef(builder.build());
    }
    
    public N endSourceRef() {
      return and();
    }
    
  
  }
  public class TargetRefNested<N> extends SecretReferenceFluent<TargetRefNested<N>> implements Nested<N>{
    TargetRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) SecretMappingFluent.this.withTargetRef(builder.build());
    }
    
    public N endTargetRef() {
      return and();
    }
    
  
  }

}