/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.BackupReference;
import io.fabric8.openshift.api.model.hive.v1.BackupReferenceBuilder;
import io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluent;
import io.fabric8.openshift.api.model.hive.v1.CheckpointSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CheckpointSpecFluent<A extends CheckpointSpecFluent<A>>
extends BaseFluent<A> {
    private String lastBackupChecksum;
    private BackupReferenceBuilder lastBackupRef;
    private String lastBackupTime;
    private Map<String, Object> additionalProperties;

    public CheckpointSpecFluent() {
    }

    public CheckpointSpecFluent(CheckpointSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CheckpointSpec instance) {
        CheckpointSpec checkpointSpec = instance = instance != null ? instance : new CheckpointSpec();
        if (instance != null) {
            this.withLastBackupChecksum(instance.getLastBackupChecksum());
            this.withLastBackupRef(instance.getLastBackupRef());
            this.withLastBackupTime(instance.getLastBackupTime());
            this.withLastBackupChecksum(instance.getLastBackupChecksum());
            this.withLastBackupRef(instance.getLastBackupRef());
            this.withLastBackupTime(instance.getLastBackupTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getLastBackupChecksum() {
        return this.lastBackupChecksum;
    }

    public A withLastBackupChecksum(String lastBackupChecksum) {
        this.lastBackupChecksum = lastBackupChecksum;
        return (A)((Object)this);
    }

    public boolean hasLastBackupChecksum() {
        return this.lastBackupChecksum != null;
    }

    public BackupReference buildLastBackupRef() {
        return this.lastBackupRef != null ? this.lastBackupRef.build() : null;
    }

    public A withLastBackupRef(BackupReference lastBackupRef) {
        this._visitables.remove((Object)this.lastBackupRef);
        if (lastBackupRef != null) {
            this.lastBackupRef = new BackupReferenceBuilder(lastBackupRef);
            this._visitables.get((Object)"lastBackupRef").add(this.lastBackupRef);
        } else {
            this.lastBackupRef = null;
            this._visitables.get((Object)"lastBackupRef").remove((Object)this.lastBackupRef);
        }
        return (A)((Object)this);
    }

    public boolean hasLastBackupRef() {
        return this.lastBackupRef != null;
    }

    public A withNewLastBackupRef(String name, String namespace) {
        return this.withLastBackupRef(new BackupReference(name, namespace));
    }

    public LastBackupRefNested<A> withNewLastBackupRef() {
        return new LastBackupRefNested(null);
    }

    public LastBackupRefNested<A> withNewLastBackupRefLike(BackupReference item) {
        return new LastBackupRefNested(item);
    }

    public LastBackupRefNested<A> editLastBackupRef() {
        return this.withNewLastBackupRefLike(Optional.ofNullable(this.buildLastBackupRef()).orElse(null));
    }

    public LastBackupRefNested<A> editOrNewLastBackupRef() {
        return this.withNewLastBackupRefLike(Optional.ofNullable(this.buildLastBackupRef()).orElse(new BackupReferenceBuilder().build()));
    }

    public LastBackupRefNested<A> editOrNewLastBackupRefLike(BackupReference item) {
        return this.withNewLastBackupRefLike(Optional.ofNullable(this.buildLastBackupRef()).orElse(item));
    }

    public String getLastBackupTime() {
        return this.lastBackupTime;
    }

    public A withLastBackupTime(String lastBackupTime) {
        this.lastBackupTime = lastBackupTime;
        return (A)((Object)this);
    }

    public boolean hasLastBackupTime() {
        return this.lastBackupTime != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CheckpointSpecFluent that = (CheckpointSpecFluent)((Object)o);
        if (!Objects.equals(this.lastBackupChecksum, that.lastBackupChecksum)) {
            return false;
        }
        if (!Objects.equals((Object)this.lastBackupRef, (Object)that.lastBackupRef)) {
            return false;
        }
        if (!Objects.equals(this.lastBackupTime, that.lastBackupTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastBackupChecksum, this.lastBackupRef, this.lastBackupTime, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lastBackupChecksum != null) {
            sb.append("lastBackupChecksum:");
            sb.append(this.lastBackupChecksum + ",");
        }
        if (this.lastBackupRef != null) {
            sb.append("lastBackupRef:");
            sb.append((Object)((Object)this.lastBackupRef) + ",");
        }
        if (this.lastBackupTime != null) {
            sb.append("lastBackupTime:");
            sb.append(this.lastBackupTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LastBackupRefNested<N>
    extends BackupReferenceFluent<LastBackupRefNested<N>>
    implements Nested<N> {
        BackupReferenceBuilder builder;

        LastBackupRefNested(BackupReference item) {
            this.builder = new BackupReferenceBuilder(this, item);
        }

        public N and() {
            return (N)CheckpointSpecFluent.this.withLastBackupRef(this.builder.build());
        }

        public N endLastBackupRef() {
            return this.and();
        }
    }
}

