/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSet;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterImageSetListFluent<A extends ClusterImageSetListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<ClusterImageSetBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;
    private Map<String, Object> additionalProperties;

    public ClusterImageSetListFluent() {
    }

    public ClusterImageSetListFluent(ClusterImageSetList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterImageSetList instance) {
        ClusterImageSetList clusterImageSetList = instance = instance != null ? instance : new ClusterImageSetList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToItems(int index, ClusterImageSet item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ClusterImageSetBuilder builder = new ClusterImageSetBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToItems(int index, ClusterImageSet item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ClusterImageSetBuilder builder = new ClusterImageSetBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(ClusterImageSet ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ClusterImageSet item : items) {
            ClusterImageSetBuilder builder = new ClusterImageSetBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToItems(Collection<ClusterImageSet> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ClusterImageSet item : items) {
            ClusterImageSetBuilder builder = new ClusterImageSetBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromItems(ClusterImageSet ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (ClusterImageSet item : items) {
            ClusterImageSetBuilder builder = new ClusterImageSetBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromItems(Collection<ClusterImageSet> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (ClusterImageSet item : items) {
            ClusterImageSetBuilder builder = new ClusterImageSetBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<ClusterImageSetBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterImageSetBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ClusterImageSetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterImageSet> buildItems() {
        return this.items != null ? ClusterImageSetListFluent.build(this.items) : null;
    }

    public ClusterImageSet buildItem(int index) {
        return this.items.get(index).build();
    }

    public ClusterImageSet buildFirstItem() {
        return this.items.get(0).build();
    }

    public ClusterImageSet buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public ClusterImageSet buildMatchingItem(Predicate<ClusterImageSetBuilder> predicate) {
        for (ClusterImageSetBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<ClusterImageSetBuilder> predicate) {
        for (ClusterImageSetBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<ClusterImageSet> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ClusterImageSet item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(ClusterImageSet ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (ClusterImageSet item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(ClusterImageSet item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, ClusterImageSet item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<ClusterImageSetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterImageSetListFluent that = (ClusterImageSetListFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ItemsNested<N>
    extends ClusterImageSetFluent<ItemsNested<N>>
    implements Nested<N> {
        ClusterImageSetBuilder builder;
        int index;

        ItemsNested(int index, ClusterImageSet item) {
            this.index = index;
            this.builder = new ClusterImageSetBuilder(this, item);
        }

        public N and() {
            return (N)ClusterImageSetListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

