package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterRelocateSpecBuilder extends ClusterRelocateSpecFluent<ClusterRelocateSpecBuilder> implements VisitableBuilder<ClusterRelocateSpec,ClusterRelocateSpecBuilder>{
  public ClusterRelocateSpecBuilder() {
    this(new ClusterRelocateSpec());
  }
  
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent) {
    this(fluent, new ClusterRelocateSpec());
  }
  
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,ClusterRelocateSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterRelocateSpecBuilder(ClusterRelocateSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterRelocateSpecFluent<?> fluent;
  
  public ClusterRelocateSpec build() {
    ClusterRelocateSpec buildable = new ClusterRelocateSpec(fluent.buildClusterDeploymentSelector(),fluent.buildKubeconfigSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}