package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceAttachmentBuilder extends ServiceAttachmentFluent<ServiceAttachmentBuilder> implements VisitableBuilder<ServiceAttachment,ServiceAttachmentBuilder>{
  public ServiceAttachmentBuilder() {
    this(new ServiceAttachment());
  }
  
  public ServiceAttachmentBuilder(ServiceAttachmentFluent<?> fluent) {
    this(fluent, new ServiceAttachment());
  }
  
  public ServiceAttachmentBuilder(ServiceAttachmentFluent<?> fluent,ServiceAttachment instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceAttachmentBuilder(ServiceAttachment instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceAttachmentFluent<?> fluent;
  
  public ServiceAttachment build() {
    ServiceAttachment buildable = new ServiceAttachment(fluent.buildSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}