package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSPrivateLinkVPCFluent<A extends AWSPrivateLinkVPCFluent<A>> extends BaseFluent<A>{
  public AWSPrivateLinkVPCFluent() {
  }
  
  public AWSPrivateLinkVPCFluent(AWSPrivateLinkVPC instance) {
    this.copyInstance(instance);
  }
  private String region;
  private String vpcID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSPrivateLinkVPC instance) {
    instance = (instance != null ? instance : new AWSPrivateLinkVPC());
    if (instance != null) {
          this.withRegion(instance.getRegion());
          this.withVpcID(instance.getVpcID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getVpcID() {
    return this.vpcID;
  }
  
  public A withVpcID(String vpcID) {
    this.vpcID = vpcID;
    return (A) this;
  }
  
  public boolean hasVpcID() {
    return this.vpcID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPrivateLinkVPCFluent that = (AWSPrivateLinkVPCFluent) o;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(vpcID, that.vpcID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(region,  vpcID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (vpcID != null) { sb.append("vpcID:"); sb.append(vpcID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}