package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPPrivateServiceConnectConfigFluent<A extends GCPPrivateServiceConnectConfigFluent<A>> extends BaseFluent<A>{
  public GCPPrivateServiceConnectConfigFluent() {
  }
  
  public GCPPrivateServiceConnectConfigFluent(GCPPrivateServiceConnectConfig instance) {
    this.copyInstance(instance);
  }
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private ArrayList<GCPPrivateServiceConnectInventoryBuilder> endpointVPCInventory = new ArrayList<GCPPrivateServiceConnectInventoryBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPPrivateServiceConnectConfig instance) {
    instance = (instance != null ? instance : new GCPPrivateServiceConnectConfig());
    if (instance != null) {
          this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
          this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
  }
  
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    this._visitables.remove("credentialsSecretRef");
    if (credentialsSecretRef != null) {
        this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
        this._visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);
    } else {
        this.credentialsSecretRef = null;
        this._visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new CredentialsSecretRefNested(null);
  }
  
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new CredentialsSecretRefNested(item);
  }
  
  public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(null));
  }
  
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(item));
  }
  
  public A addToEndpointVPCInventory(int index,GCPPrivateServiceConnectInventory item) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<GCPPrivateServiceConnectInventoryBuilder>();}
    GCPPrivateServiceConnectInventoryBuilder builder = new GCPPrivateServiceConnectInventoryBuilder(item);
    if (index < 0 || index >= endpointVPCInventory.size()) {
        _visitables.get("endpointVPCInventory").add(builder);
        endpointVPCInventory.add(builder);
    } else {
        _visitables.get("endpointVPCInventory").add(builder);
        endpointVPCInventory.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToEndpointVPCInventory(int index,GCPPrivateServiceConnectInventory item) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<GCPPrivateServiceConnectInventoryBuilder>();}
    GCPPrivateServiceConnectInventoryBuilder builder = new GCPPrivateServiceConnectInventoryBuilder(item);
    if (index < 0 || index >= endpointVPCInventory.size()) {
        _visitables.get("endpointVPCInventory").add(builder);
        endpointVPCInventory.add(builder);
    } else {
        _visitables.get("endpointVPCInventory").add(builder);
        endpointVPCInventory.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToEndpointVPCInventory(io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectInventory... items) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<GCPPrivateServiceConnectInventoryBuilder>();}
    for (GCPPrivateServiceConnectInventory item : items) {GCPPrivateServiceConnectInventoryBuilder builder = new GCPPrivateServiceConnectInventoryBuilder(item);_visitables.get("endpointVPCInventory").add(builder);this.endpointVPCInventory.add(builder);} return (A)this;
  }
  
  public A addAllToEndpointVPCInventory(Collection<GCPPrivateServiceConnectInventory> items) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<GCPPrivateServiceConnectInventoryBuilder>();}
    for (GCPPrivateServiceConnectInventory item : items) {GCPPrivateServiceConnectInventoryBuilder builder = new GCPPrivateServiceConnectInventoryBuilder(item);_visitables.get("endpointVPCInventory").add(builder);this.endpointVPCInventory.add(builder);} return (A)this;
  }
  
  public A removeFromEndpointVPCInventory(io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectInventory... items) {
    if (this.endpointVPCInventory == null) return (A)this;
    for (GCPPrivateServiceConnectInventory item : items) {GCPPrivateServiceConnectInventoryBuilder builder = new GCPPrivateServiceConnectInventoryBuilder(item);_visitables.get("endpointVPCInventory").remove(builder); this.endpointVPCInventory.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEndpointVPCInventory(Collection<GCPPrivateServiceConnectInventory> items) {
    if (this.endpointVPCInventory == null) return (A)this;
    for (GCPPrivateServiceConnectInventory item : items) {GCPPrivateServiceConnectInventoryBuilder builder = new GCPPrivateServiceConnectInventoryBuilder(item);_visitables.get("endpointVPCInventory").remove(builder); this.endpointVPCInventory.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEndpointVPCInventory(Predicate<GCPPrivateServiceConnectInventoryBuilder> predicate) {
    if (endpointVPCInventory == null) return (A) this;
    final Iterator<GCPPrivateServiceConnectInventoryBuilder> each = endpointVPCInventory.iterator();
    final List visitables = _visitables.get("endpointVPCInventory");
    while (each.hasNext()) {
      GCPPrivateServiceConnectInventoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCPPrivateServiceConnectInventory> buildEndpointVPCInventory() {
    return this.endpointVPCInventory != null ? build(endpointVPCInventory) : null;
  }
  
  public GCPPrivateServiceConnectInventory buildEndpointVPCInventory(int index) {
    return this.endpointVPCInventory.get(index).build();
  }
  
  public GCPPrivateServiceConnectInventory buildFirstEndpointVPCInventory() {
    return this.endpointVPCInventory.get(0).build();
  }
  
  public GCPPrivateServiceConnectInventory buildLastEndpointVPCInventory() {
    return this.endpointVPCInventory.get(endpointVPCInventory.size() - 1).build();
  }
  
  public GCPPrivateServiceConnectInventory buildMatchingEndpointVPCInventory(Predicate<GCPPrivateServiceConnectInventoryBuilder> predicate) {
      for (GCPPrivateServiceConnectInventoryBuilder item : endpointVPCInventory) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEndpointVPCInventory(Predicate<GCPPrivateServiceConnectInventoryBuilder> predicate) {
      for (GCPPrivateServiceConnectInventoryBuilder item : endpointVPCInventory) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEndpointVPCInventory(List<GCPPrivateServiceConnectInventory> endpointVPCInventory) {
    if (this.endpointVPCInventory != null) {
      this._visitables.get("endpointVPCInventory").clear();
    }
    if (endpointVPCInventory != null) {
        this.endpointVPCInventory = new ArrayList();
        for (GCPPrivateServiceConnectInventory item : endpointVPCInventory) {
          this.addToEndpointVPCInventory(item);
        }
    } else {
      this.endpointVPCInventory = null;
    }
    return (A) this;
  }
  
  public A withEndpointVPCInventory(io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectInventory... endpointVPCInventory) {
    if (this.endpointVPCInventory != null) {
        this.endpointVPCInventory.clear();
        _visitables.remove("endpointVPCInventory");
    }
    if (endpointVPCInventory != null) {
      for (GCPPrivateServiceConnectInventory item : endpointVPCInventory) {
        this.addToEndpointVPCInventory(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEndpointVPCInventory() {
    return this.endpointVPCInventory != null && !this.endpointVPCInventory.isEmpty();
  }
  
  public EndpointVPCInventoryNested<A> addNewEndpointVPCInventory() {
    return new EndpointVPCInventoryNested(-1, null);
  }
  
  public EndpointVPCInventoryNested<A> addNewEndpointVPCInventoryLike(GCPPrivateServiceConnectInventory item) {
    return new EndpointVPCInventoryNested(-1, item);
  }
  
  public EndpointVPCInventoryNested<A> setNewEndpointVPCInventoryLike(int index,GCPPrivateServiceConnectInventory item) {
    return new EndpointVPCInventoryNested(index, item);
  }
  
  public EndpointVPCInventoryNested<A> editEndpointVPCInventory(int index) {
    if (endpointVPCInventory.size() <= index) throw new RuntimeException("Can't edit endpointVPCInventory. Index exceeds size.");
    return setNewEndpointVPCInventoryLike(index, buildEndpointVPCInventory(index));
  }
  
  public EndpointVPCInventoryNested<A> editFirstEndpointVPCInventory() {
    if (endpointVPCInventory.size() == 0) throw new RuntimeException("Can't edit first endpointVPCInventory. The list is empty.");
    return setNewEndpointVPCInventoryLike(0, buildEndpointVPCInventory(0));
  }
  
  public EndpointVPCInventoryNested<A> editLastEndpointVPCInventory() {
    int index = endpointVPCInventory.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpointVPCInventory. The list is empty.");
    return setNewEndpointVPCInventoryLike(index, buildEndpointVPCInventory(index));
  }
  
  public EndpointVPCInventoryNested<A> editMatchingEndpointVPCInventory(Predicate<GCPPrivateServiceConnectInventoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpointVPCInventory.size();i++) { 
    if (predicate.test(endpointVPCInventory.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpointVPCInventory. No match found.");
    return setNewEndpointVPCInventoryLike(index, buildEndpointVPCInventory(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPPrivateServiceConnectConfigFluent that = (GCPPrivateServiceConnectConfigFluent) o;
    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;
    if (!java.util.Objects.equals(endpointVPCInventory, that.endpointVPCInventory)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(credentialsSecretRef,  endpointVPCInventory,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (endpointVPCInventory != null && !endpointVPCInventory.isEmpty()) { sb.append("endpointVPCInventory:"); sb.append(endpointVPCInventory + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CredentialsSecretRefNested<N> extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>> implements Nested<N>{
    CredentialsSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) GCPPrivateServiceConnectConfigFluent.this.withCredentialsSecretRef(builder.build());
    }
    
    public N endCredentialsSecretRef() {
      return and();
    }
    
  
  }
  public class EndpointVPCInventoryNested<N> extends GCPPrivateServiceConnectInventoryFluent<EndpointVPCInventoryNested<N>> implements Nested<N>{
    EndpointVPCInventoryNested(int index,GCPPrivateServiceConnectInventory item) {
      this.index = index;
      this.builder = new GCPPrivateServiceConnectInventoryBuilder(this, item);
    }
    GCPPrivateServiceConnectInventoryBuilder builder;
    int index;
    
    public N and() {
      return (N) GCPPrivateServiceConnectConfigFluent.this.setToEndpointVPCInventory(index,builder.build());
    }
    
    public N endEndpointVPCInventory() {
      return and();
    }
    
  
  }

}