package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PrivateServiceConnectBuilder extends PrivateServiceConnectFluent<PrivateServiceConnectBuilder> implements VisitableBuilder<PrivateServiceConnect,PrivateServiceConnectBuilder>{
  public PrivateServiceConnectBuilder() {
    this(new PrivateServiceConnect());
  }
  
  public PrivateServiceConnectBuilder(PrivateServiceConnectFluent<?> fluent) {
    this(fluent, new PrivateServiceConnect());
  }
  
  public PrivateServiceConnectBuilder(PrivateServiceConnectFluent<?> fluent,PrivateServiceConnect instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PrivateServiceConnectBuilder(PrivateServiceConnect instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PrivateServiceConnectFluent<?> fluent;
  
  public PrivateServiceConnect build() {
    PrivateServiceConnect buildable = new PrivateServiceConnect(fluent.getEnabled(),fluent.buildServiceAttachment());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}