package io.fabric8.openshift.api.model.hive.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceAttachmentSubnetFluent<A extends ServiceAttachmentSubnetFluent<A>> extends BaseFluent<A>{
  public ServiceAttachmentSubnetFluent() {
  }
  
  public ServiceAttachmentSubnetFluent(ServiceAttachmentSubnet instance) {
    this.copyInstance(instance);
  }
  private String cidr;
  private ServiceAttachmentSubnetExistingBuilder existing;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceAttachmentSubnet instance) {
    instance = (instance != null ? instance : new ServiceAttachmentSubnet());
    if (instance != null) {
          this.withCidr(instance.getCidr());
          this.withExisting(instance.getExisting());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCidr() {
    return this.cidr;
  }
  
  public A withCidr(String cidr) {
    this.cidr = cidr;
    return (A) this;
  }
  
  public boolean hasCidr() {
    return this.cidr != null;
  }
  
  public ServiceAttachmentSubnetExisting buildExisting() {
    return this.existing != null ? this.existing.build() : null;
  }
  
  public A withExisting(ServiceAttachmentSubnetExisting existing) {
    this._visitables.remove("existing");
    if (existing != null) {
        this.existing = new ServiceAttachmentSubnetExistingBuilder(existing);
        this._visitables.get("existing").add(this.existing);
    } else {
        this.existing = null;
        this._visitables.get("existing").remove(this.existing);
    }
    return (A) this;
  }
  
  public boolean hasExisting() {
    return this.existing != null;
  }
  
  public A withNewExisting(String name,String project) {
    return (A)withExisting(new ServiceAttachmentSubnetExisting(name, project));
  }
  
  public ExistingNested<A> withNewExisting() {
    return new ExistingNested(null);
  }
  
  public ExistingNested<A> withNewExistingLike(ServiceAttachmentSubnetExisting item) {
    return new ExistingNested(item);
  }
  
  public ExistingNested<A> editExisting() {
    return withNewExistingLike(java.util.Optional.ofNullable(buildExisting()).orElse(null));
  }
  
  public ExistingNested<A> editOrNewExisting() {
    return withNewExistingLike(java.util.Optional.ofNullable(buildExisting()).orElse(new ServiceAttachmentSubnetExistingBuilder().build()));
  }
  
  public ExistingNested<A> editOrNewExistingLike(ServiceAttachmentSubnetExisting item) {
    return withNewExistingLike(java.util.Optional.ofNullable(buildExisting()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceAttachmentSubnetFluent that = (ServiceAttachmentSubnetFluent) o;
    if (!java.util.Objects.equals(cidr, that.cidr)) return false;
    if (!java.util.Objects.equals(existing, that.existing)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cidr,  existing,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cidr != null) { sb.append("cidr:"); sb.append(cidr + ","); }
    if (existing != null) { sb.append("existing:"); sb.append(existing + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExistingNested<N> extends ServiceAttachmentSubnetExistingFluent<ExistingNested<N>> implements Nested<N>{
    ExistingNested(ServiceAttachmentSubnetExisting item) {
      this.builder = new ServiceAttachmentSubnetExistingBuilder(this, item);
    }
    ServiceAttachmentSubnetExistingBuilder builder;
    
    public N and() {
      return (N) ServiceAttachmentSubnetFluent.this.withExisting(builder.build());
    }
    
    public N endExisting() {
      return and();
    }
    
  
  }

}