package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FeatureGatesEnabledFluent<A extends FeatureGatesEnabledFluent<A>> extends BaseFluent<A>{
  public FeatureGatesEnabledFluent() {
  }
  
  public FeatureGatesEnabledFluent(FeatureGatesEnabled instance) {
    this.copyInstance(instance);
  }
  private List<String> enabled = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FeatureGatesEnabled instance) {
    instance = (instance != null ? instance : new FeatureGatesEnabled());
    if (instance != null) {
          this.withEnabled(instance.getEnabled());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToEnabled(int index,String item) {
    if (this.enabled == null) {this.enabled = new ArrayList<String>();}
    this.enabled.add(index, item);
    return (A)this;
  }
  
  public A setToEnabled(int index,String item) {
    if (this.enabled == null) {this.enabled = new ArrayList<String>();}
    this.enabled.set(index, item); return (A)this;
  }
  
  public A addToEnabled(java.lang.String... items) {
    if (this.enabled == null) {this.enabled = new ArrayList<String>();}
    for (String item : items) {this.enabled.add(item);} return (A)this;
  }
  
  public A addAllToEnabled(Collection<String> items) {
    if (this.enabled == null) {this.enabled = new ArrayList<String>();}
    for (String item : items) {this.enabled.add(item);} return (A)this;
  }
  
  public A removeFromEnabled(java.lang.String... items) {
    if (this.enabled == null) return (A)this;
    for (String item : items) { this.enabled.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnabled(Collection<String> items) {
    if (this.enabled == null) return (A)this;
    for (String item : items) { this.enabled.remove(item);} return (A)this;
  }
  
  public List<String> getEnabled() {
    return this.enabled;
  }
  
  public String getEnabled(int index) {
    return this.enabled.get(index);
  }
  
  public String getFirstEnabled() {
    return this.enabled.get(0);
  }
  
  public String getLastEnabled() {
    return this.enabled.get(enabled.size() - 1);
  }
  
  public String getMatchingEnabled(Predicate<String> predicate) {
      for (String item : enabled) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnabled(Predicate<String> predicate) {
      for (String item : enabled) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnabled(List<String> enabled) {
    if (enabled != null) {
        this.enabled = new ArrayList();
        for (String item : enabled) {
          this.addToEnabled(item);
        }
    } else {
      this.enabled = null;
    }
    return (A) this;
  }
  
  public A withEnabled(java.lang.String... enabled) {
    if (this.enabled != null) {
        this.enabled.clear();
        _visitables.remove("enabled");
    }
    if (enabled != null) {
      for (String item : enabled) {
        this.addToEnabled(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return this.enabled != null && !this.enabled.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FeatureGatesEnabledFluent that = (FeatureGatesEnabledFluent) o;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabled != null && !enabled.isEmpty()) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}