package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EncryptionKeyReferenceBuilder extends io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluentImpl<io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference,io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceBuilder>{
  public EncryptionKeyReferenceBuilder() {
    this(false);
  }
  public EncryptionKeyReferenceBuilder(java.lang.Boolean validationEnabled) {
    this(new EncryptionKeyReference(), validationEnabled);
  }
  public EncryptionKeyReferenceBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public EncryptionKeyReferenceBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EncryptionKeyReference(), validationEnabled);
  }
  public EncryptionKeyReferenceBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluent<?> fluent,io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference instance) {
    this(fluent, instance, false);
  }
  public EncryptionKeyReferenceBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluent<?> fluent,io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKmsKey(instance.getKmsKey()); 
    fluent.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EncryptionKeyReferenceBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference instance) {
    this(instance,false);
  }
  public EncryptionKeyReferenceBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKmsKey(instance.getKmsKey()); 
    this.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference build() {
    EncryptionKeyReference buildable = new EncryptionKeyReference(fluent.getKmsKey(),fluent.getKmsKeyServiceAccount());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EncryptionKeyReferenceBuilder that = (EncryptionKeyReferenceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}