package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlatformBuilder extends io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluentImpl<io.fabric8.openshift.api.model.installer.openstack.v1.PlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.openstack.v1.Platform,io.fabric8.openshift.api.model.installer.openstack.v1.PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.openstack.v1.Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.openstack.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiFloatingIP(instance.getApiFloatingIP()); 
    fluent.withApiVIP(instance.getApiVIP()); 
    fluent.withCloud(instance.getCloud()); 
    fluent.withClusterOSImage(instance.getClusterOSImage()); 
    fluent.withClusterOSImageProperties(instance.getClusterOSImageProperties()); 
    fluent.withComputeFlavor(instance.getComputeFlavor()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withExternalDNS(instance.getExternalDNS()); 
    fluent.withExternalNetwork(instance.getExternalNetwork()); 
    fluent.withIngressFloatingIP(instance.getIngressFloatingIP()); 
    fluent.withIngressVIP(instance.getIngressVIP()); 
    fluent.withLbFloatingIP(instance.getLbFloatingIP()); 
    fluent.withMachinesSubnet(instance.getMachinesSubnet()); 
    fluent.withOctaviaSupport(instance.getOctaviaSupport()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withTrunkSupport(instance.getTrunkSupport()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.openstack.v1.Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.openstack.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiFloatingIP(instance.getApiFloatingIP()); 
    this.withApiVIP(instance.getApiVIP()); 
    this.withCloud(instance.getCloud()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withClusterOSImageProperties(instance.getClusterOSImageProperties()); 
    this.withComputeFlavor(instance.getComputeFlavor()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withExternalDNS(instance.getExternalDNS()); 
    this.withExternalNetwork(instance.getExternalNetwork()); 
    this.withIngressFloatingIP(instance.getIngressFloatingIP()); 
    this.withIngressVIP(instance.getIngressVIP()); 
    this.withLbFloatingIP(instance.getLbFloatingIP()); 
    this.withMachinesSubnet(instance.getMachinesSubnet()); 
    this.withOctaviaSupport(instance.getOctaviaSupport()); 
    this.withRegion(instance.getRegion()); 
    this.withTrunkSupport(instance.getTrunkSupport()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.openstack.v1.Platform build() {
    Platform buildable = new Platform(fluent.getApiFloatingIP(),fluent.getApiVIP(),fluent.getCloud(),fluent.getClusterOSImage(),fluent.getClusterOSImageProperties(),fluent.getComputeFlavor(),fluent.getDefaultMachinePlatform(),fluent.getExternalDNS(),fluent.getExternalNetwork(),fluent.getIngressFloatingIP(),fluent.getIngressVIP(),fluent.getLbFloatingIP(),fluent.getMachinesSubnet(),fluent.getOctaviaSupport(),fluent.getRegion(),fluent.getTrunkSupport());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformBuilder that = (PlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}