package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class NetworkingFluentImpl<A extends io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<A>{
  public NetworkingFluentImpl() {
  }
  public NetworkingFluentImpl(io.fabric8.openshift.api.model.installer.v1.Networking instance) {
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks()); 
    this.withMachineCIDR(instance.getMachineCIDR()); 
    this.withMachineNetwork(instance.getMachineNetwork()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceCIDR(instance.getServiceCIDR()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> clusterNetwork =  new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();
  private java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> deprecatedClusterNetworks =  new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();
  private java.lang.String machineCIDR;
  private java.util.List<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder> machineNetwork =  new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder>();
  private java.lang.String networkType;
  private java.lang.String serviceCIDR;
  private java.util.List<java.lang.String> serviceNetwork = new java.util.ArrayList<java.lang.String>();
  private java.lang.String type;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToClusterNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
  }
  public A setToClusterNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
    if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> items) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> getClusterNetwork() {
    return build(clusterNetwork);
  }
  public java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> buildClusterNetwork() {
    return build(clusterNetwork);
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildClusterNetwork(java.lang.Integer index) {
    return this.clusterNetwork.get(index).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
    if (clusterNetwork != null) {this.clusterNetwork = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
    if (clusterNetwork != null) {for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(java.lang.String cidr,java.lang.Integer hostPrefix,java.lang.Integer hostSubnetLength) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.ClusterNetworkNestedImpl();
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> editClusterNetwork(java.lang.Integer index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public A addToDeprecatedClusterNetworks(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").add(index >= 0 ? index : _visitables.get("deprecatedClusterNetworks").size(), builder);this.deprecatedClusterNetworks.add(index >= 0 ? index : deprecatedClusterNetworks.size(), builder); return (A)this;
  }
  public A setToDeprecatedClusterNetworks(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("deprecatedClusterNetworks").size()) { _visitables.get("deprecatedClusterNetworks").add(builder); } else { _visitables.get("deprecatedClusterNetworks").set(index, builder);}
    if (index < 0 || index >= deprecatedClusterNetworks.size()) { deprecatedClusterNetworks.add(builder); } else { deprecatedClusterNetworks.set(index, builder);}
     return (A)this;
  }
  public A addToDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").add(builder);this.deprecatedClusterNetworks.add(builder);} return (A)this;
  }
  public A addAllToDeprecatedClusterNetworks(java.util.Collection<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> items) {
    if (this.deprecatedClusterNetworks == null) {this.deprecatedClusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").add(builder);this.deprecatedClusterNetworks.add(builder);} return (A)this;
  }
  public A removeFromDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").remove(builder);if (this.deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks.remove(builder);}} return (A)this;
  }
  public A removeAllFromDeprecatedClusterNetworks(java.util.Collection<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> items) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(item);_visitables.get("deprecatedClusterNetworks").remove(builder);if (this.deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDeprecatedClusterNetworks(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    if (deprecatedClusterNetworks == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> each = deprecatedClusterNetworks.iterator();
    final List visitables = _visitables.get("deprecatedClusterNetworks");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDeprecatedClusterNetworks instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> getDeprecatedClusterNetworks() {
    return build(deprecatedClusterNetworks);
  }
  public java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> buildDeprecatedClusterNetworks() {
    return build(deprecatedClusterNetworks);
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildDeprecatedClusterNetwork(java.lang.Integer index) {
    return this.deprecatedClusterNetworks.get(index).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildFirstDeprecatedClusterNetwork() {
    return this.deprecatedClusterNetworks.get(0).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildLastDeprecatedClusterNetwork() {
    return this.deprecatedClusterNetworks.get(deprecatedClusterNetworks.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry buildMatchingDeprecatedClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder item: deprecatedClusterNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingDeprecatedClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder item: deprecatedClusterNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDeprecatedClusterNetworks(java.util.List<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry> deprecatedClusterNetworks) {
    if (this.deprecatedClusterNetworks != null) { _visitables.get("deprecatedClusterNetworks").removeAll(this.deprecatedClusterNetworks);}
    if (deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item : deprecatedClusterNetworks){this.addToDeprecatedClusterNetworks(item);}} else { this.deprecatedClusterNetworks = null;} return (A) this;
  }
  public A withDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... deprecatedClusterNetworks) {
    if (this.deprecatedClusterNetworks != null) {this.deprecatedClusterNetworks.clear();}
    if (deprecatedClusterNetworks != null) {for (io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item :deprecatedClusterNetworks){ this.addToDeprecatedClusterNetworks(item);}} return (A) this;
  }
  public java.lang.Boolean hasDeprecatedClusterNetworks() {
    return deprecatedClusterNetworks != null && !deprecatedClusterNetworks.isEmpty();
  }
  public A addNewDeprecatedClusterNetwork(java.lang.String cidr,java.lang.Integer hostPrefix,java.lang.Integer hostSubnetLength) {
    return (A)addToDeprecatedClusterNetworks(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetwork() {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.DeprecatedClusterNetworksNestedImpl();
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetworkLike(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.DeprecatedClusterNetworksNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> setNewDeprecatedClusterNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.DeprecatedClusterNetworksNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> editDeprecatedClusterNetwork(java.lang.Integer index) {
    if (deprecatedClusterNetworks.size() <= index) throw new RuntimeException("Can't edit deprecatedClusterNetworks. Index exceeds size.");
    return setNewDeprecatedClusterNetworkLike(index, buildDeprecatedClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> editFirstDeprecatedClusterNetwork() {
    if (deprecatedClusterNetworks.size() == 0) throw new RuntimeException("Can't edit first deprecatedClusterNetworks. The list is empty.");
    return setNewDeprecatedClusterNetworkLike(0, buildDeprecatedClusterNetwork(0));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> editLastDeprecatedClusterNetwork() {
    int index = deprecatedClusterNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last deprecatedClusterNetworks. The list is empty.");
    return setNewDeprecatedClusterNetworkLike(index, buildDeprecatedClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<A> editMatchingDeprecatedClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<deprecatedClusterNetworks.size();i++) { 
    if (predicate.test(deprecatedClusterNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching deprecatedClusterNetworks. No match found.");
    return setNewDeprecatedClusterNetworkLike(index, buildDeprecatedClusterNetwork(index));
  }
  public java.lang.String getMachineCIDR() {
    return this.machineCIDR;
  }
  public A withMachineCIDR(java.lang.String machineCIDR) {
    this.machineCIDR=machineCIDR; return (A) this;
  }
  public java.lang.Boolean hasMachineCIDR() {
    return this.machineCIDR != null;
  }
  
  /**
   * Method is deprecated. use withMachineCIDR instead.
   */
  @java.lang.Deprecated
  public A withNewMachineCIDR(java.lang.String arg0) {
    return (A)withMachineCIDR(new String(arg0));
  }
  public A addToMachineNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item) {
    if (this.machineNetwork == null) {this.machineNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(index >= 0 ? index : _visitables.get("machineNetwork").size(), builder);this.machineNetwork.add(index >= 0 ? index : machineNetwork.size(), builder); return (A)this;
  }
  public A setToMachineNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item) {
    if (this.machineNetwork == null) {this.machineNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("machineNetwork").size()) { _visitables.get("machineNetwork").add(builder); } else { _visitables.get("machineNetwork").set(index, builder);}
    if (index < 0 || index >= machineNetwork.size()) { machineNetwork.add(builder); } else { machineNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items) {
    if (this.machineNetwork == null) {this.machineNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(builder);this.machineNetwork.add(builder);} return (A)this;
  }
  public A addAllToMachineNetwork(java.util.Collection<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry> items) {
    if (this.machineNetwork == null) {this.machineNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(builder);this.machineNetwork.add(builder);} return (A)this;
  }
  public A removeFromMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items) {
    for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").remove(builder);if (this.machineNetwork != null) {this.machineNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromMachineNetwork(java.util.Collection<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry> items) {
    for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item : items) {io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").remove(builder);if (this.machineNetwork != null) {this.machineNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMachineNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder> predicate) {
    if (machineNetwork == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder> each = machineNetwork.iterator();
    final List visitables = _visitables.get("machineNetwork");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMachineNetwork instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry> getMachineNetwork() {
    return build(machineNetwork);
  }
  public java.util.List<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry> buildMachineNetwork() {
    return build(machineNetwork);
  }
  public io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry buildMachineNetwork(java.lang.Integer index) {
    return this.machineNetwork.get(index).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry buildFirstMachineNetwork() {
    return this.machineNetwork.get(0).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry buildLastMachineNetwork() {
    return this.machineNetwork.get(machineNetwork.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry buildMatchingMachineNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder item: machineNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMachineNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder item: machineNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMachineNetwork(java.util.List<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry> machineNetwork) {
    if (this.machineNetwork != null) { _visitables.get("machineNetwork").removeAll(this.machineNetwork);}
    if (machineNetwork != null) {this.machineNetwork = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item : machineNetwork){this.addToMachineNetwork(item);}} else { this.machineNetwork = null;} return (A) this;
  }
  public A withMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... machineNetwork) {
    if (this.machineNetwork != null) {this.machineNetwork.clear();}
    if (machineNetwork != null) {for (io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item :machineNetwork){ this.addToMachineNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasMachineNetwork() {
    return machineNetwork != null && !machineNetwork.isEmpty();
  }
  public A addNewMachineNetwork(java.lang.String cidr) {
    return (A)addToMachineNetwork(new MachineNetworkEntry(cidr));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> addNewMachineNetwork() {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.MachineNetworkNestedImpl();
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> addNewMachineNetworkLike(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item) {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.MachineNetworkNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> setNewMachineNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item) {
    return new io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl.MachineNetworkNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> editMachineNetwork(java.lang.Integer index) {
    if (machineNetwork.size() <= index) throw new RuntimeException("Can't edit machineNetwork. Index exceeds size.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> editFirstMachineNetwork() {
    if (machineNetwork.size() == 0) throw new RuntimeException("Can't edit first machineNetwork. The list is empty.");
    return setNewMachineNetworkLike(0, buildMachineNetwork(0));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> editLastMachineNetwork() {
    int index = machineNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last machineNetwork. The list is empty.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  public io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<A> editMatchingMachineNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<machineNetwork.size();i++) { 
    if (predicate.test(machineNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching machineNetwork. No match found.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  public java.lang.String getNetworkType() {
    return this.networkType;
  }
  public A withNetworkType(java.lang.String networkType) {
    this.networkType=networkType; return (A) this;
  }
  public java.lang.Boolean hasNetworkType() {
    return this.networkType != null;
  }
  
  /**
   * Method is deprecated. use withNetworkType instead.
   */
  @java.lang.Deprecated
  public A withNewNetworkType(java.lang.String arg0) {
    return (A)withNetworkType(new String(arg0));
  }
  public java.lang.String getServiceCIDR() {
    return this.serviceCIDR;
  }
  public A withServiceCIDR(java.lang.String serviceCIDR) {
    this.serviceCIDR=serviceCIDR; return (A) this;
  }
  public java.lang.Boolean hasServiceCIDR() {
    return this.serviceCIDR != null;
  }
  
  /**
   * Method is deprecated. use withServiceCIDR instead.
   */
  @java.lang.Deprecated
  public A withNewServiceCIDR(java.lang.String arg0) {
    return (A)withServiceCIDR(new String(arg0));
  }
  public A addToServiceNetwork(java.lang.Integer index,java.lang.String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(java.lang.Integer index,java.lang.String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(java.util.Collection<java.lang.String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public java.lang.String getServiceNetwork(java.lang.Integer index) {
    return this.serviceNetwork.get(index);
  }
  public java.lang.String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public java.lang.String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public java.lang.String getMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(java.util.List<java.lang.String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new java.util.ArrayList(); for (java.lang.String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
    if (serviceNetwork != null) {for (java.lang.String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  public A addNewServiceNetwork(java.lang.String arg0) {
    return (A)addToServiceNetwork(new String(arg0));
  }
  public java.lang.String getType() {
    return this.type;
  }
  public A withType(java.lang.String type) {
    this.type=type; return (A) this;
  }
  public java.lang.Boolean hasType() {
    return this.type != null;
  }
  
  /**
   * Method is deprecated. use withType instead.
   */
  @java.lang.Deprecated
  public A withNewType(java.lang.String arg0) {
    return (A)withType(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkingFluentImpl that = (NetworkingFluentImpl) o;
    if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
    if (deprecatedClusterNetworks != null ? !deprecatedClusterNetworks.equals(that.deprecatedClusterNetworks) :that.deprecatedClusterNetworks != null) return false;
    if (machineCIDR != null ? !machineCIDR.equals(that.machineCIDR) :that.machineCIDR != null) return false;
    if (machineNetwork != null ? !machineNetwork.equals(that.machineNetwork) :that.machineNetwork != null) return false;
    if (networkType != null ? !networkType.equals(that.networkType) :that.networkType != null) return false;
    if (serviceCIDR != null ? !serviceCIDR.equals(that.serviceCIDR) :that.serviceCIDR != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterNetwork,  deprecatedClusterNetworks,  machineCIDR,  machineNetwork,  networkType,  serviceCIDR,  serviceNetwork,  type,  additionalProperties,  super.hashCode());
  }
  public class ClusterNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<N>> implements io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.ClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworkNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(this);
    }
    io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkingFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  public class DeprecatedClusterNetworksNestedImpl<N> extends io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<N>> implements io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.DeprecatedClusterNetworksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DeprecatedClusterNetworksNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(this, item);
    }
    DeprecatedClusterNetworksNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder(this);
    }
    io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkingFluentImpl.this.setToDeprecatedClusterNetworks(index,builder.build());
    }
    public N endDeprecatedClusterNetwork() {
      return and();
    }
    
  }
  public class MachineNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryFluentImpl<io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<N>> implements io.fabric8.openshift.api.model.installer.v1.NetworkingFluent.MachineNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MachineNetworkNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(this, item);
    }
    MachineNetworkNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder(this);
    }
    io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkingFluentImpl.this.setToMachineNetwork(index,builder.build());
    }
    public N endMachineNetwork() {
      return and();
    }
    
  }
  
}