package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OSDiskBuilder extends io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluentImpl<io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk,io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskBuilder>{
  public OSDiskBuilder() {
    this(false);
  }
  public OSDiskBuilder(java.lang.Boolean validationEnabled) {
    this(new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public OSDiskBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent<?> fluent,io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk instance) {
    this(fluent, instance, false);
  }
  public OSDiskBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent<?> fluent,io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDiskSizeGB(instance.getDiskSizeGB()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OSDiskBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk instance) {
    this(instance,false);
  }
  public OSDiskBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDiskSizeGB(instance.getDiskSizeGB()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk build() {
    OSDisk buildable = new OSDisk(fluent.getDiskSizeGB());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OSDiskBuilder that = (OSDiskBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}