package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class PlatformFluentImpl<A extends io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(io.fabric8.openshift.api.model.installer.aws.v1.Platform instance) {
    this.withAmiID(instance.getAmiID()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags()); 
    this.withHostedZone(instance.getHostedZone()); 
    this.withRegion(instance.getRegion()); 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withSubnets(instance.getSubnets()); 
    this.withUserTags(instance.getUserTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String amiID;
  private io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder defaultMachinePlatform;
  private java.lang.Boolean experimentalPropagateUserTags;
  private java.lang.String hostedZone;
  private java.lang.String region;
  private java.util.List<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> serviceEndpoints =  new java.util.ArrayList<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder>();
  private java.util.List<java.lang.String> subnets = new java.util.ArrayList<java.lang.String>();
  private java.util.Map<java.lang.String,java.lang.String> userTags;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getAmiID() {
    return this.amiID;
  }
  public A withAmiID(java.lang.String amiID) {
    this.amiID=amiID; return (A) this;
  }
  public java.lang.Boolean hasAmiID() {
    return this.amiID != null;
  }
  
  /**
   * Method is deprecated. use withAmiID instead.
   */
  @java.lang.Deprecated
  public A withNewAmiID(java.lang.String arg0) {
    return (A)withAmiID(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.installer.aws.v1.MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null?this.defaultMachinePlatform.build():null;
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(io.fabric8.openshift.api.model.installer.aws.v1.MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} return (A) this;
  }
  public java.lang.Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(io.fabric8.openshift.api.model.installer.aws.v1.MachinePool item) {
    return new io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder().build());
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(io.fabric8.openshift.api.model.installer.aws.v1.MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public java.lang.Boolean getExperimentalPropagateUserTags() {
    return this.experimentalPropagateUserTags;
  }
  public A withExperimentalPropagateUserTags(java.lang.Boolean experimentalPropagateUserTags) {
    this.experimentalPropagateUserTags=experimentalPropagateUserTags; return (A) this;
  }
  public java.lang.Boolean hasExperimentalPropagateUserTags() {
    return this.experimentalPropagateUserTags != null;
  }
  public java.lang.String getHostedZone() {
    return this.hostedZone;
  }
  public A withHostedZone(java.lang.String hostedZone) {
    this.hostedZone=hostedZone; return (A) this;
  }
  public java.lang.Boolean hasHostedZone() {
    return this.hostedZone != null;
  }
  
  /**
   * Method is deprecated. use withHostedZone instead.
   */
  @java.lang.Deprecated
  public A withNewHostedZone(java.lang.String arg0) {
    return (A)withHostedZone(new String(arg0));
  }
  public java.lang.String getRegion() {
    return this.region;
  }
  public A withRegion(java.lang.String region) {
    this.region=region; return (A) this;
  }
  public java.lang.Boolean hasRegion() {
    return this.region != null;
  }
  
  /**
   * Method is deprecated. use withRegion instead.
   */
  @java.lang.Deprecated
  public A withNewRegion(java.lang.String arg0) {
    return (A)withRegion(new String(arg0));
  }
  public A addToServiceEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder>();}
    io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(index >= 0 ? index : _visitables.get("serviceEndpoints").size(), builder);this.serviceEndpoints.add(index >= 0 ? index : serviceEndpoints.size(), builder); return (A)this;
  }
  public A setToServiceEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder>();}
    io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("serviceEndpoints").size()) { _visitables.get("serviceEndpoints").add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder);}
    if (index < 0 || index >= serviceEndpoints.size()) { serviceEndpoints.add(builder); } else { serviceEndpoints.set(index, builder);}
     return (A)this;
  }
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder>();}
    for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item : items) {io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A addAllToServiceEndpoints(java.util.Collection<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder>();}
    for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item : items) {io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... items) {
    for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item : items) {io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceEndpoints(java.util.Collection<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint> items) {
    for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item : items) {io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceEndpoints(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint> getServiceEndpoints() {
    return build(serviceEndpoints);
  }
  public java.util.List<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint> buildServiceEndpoints() {
    return build(serviceEndpoints);
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint buildServiceEndpoint(java.lang.Integer index) {
    return this.serviceEndpoints.get(index).build();
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint buildMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceEndpoints(java.util.List<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);}
    if (serviceEndpoints != null) {this.serviceEndpoints = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  public A withServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear();}
    if (serviceEndpoints != null) {for (io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  public A addNewServiceEndpoint(java.lang.String name,java.lang.String url) {
    return (A)addToServiceEndpoints(new ServiceEndpoint(name, url));
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluentImpl.ServiceEndpointsNestedImpl();
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item) {
    return new io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluentImpl.ServiceEndpointsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(java.lang.Integer index,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item) {
    return new io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluentImpl.ServiceEndpointsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> editServiceEndpoint(java.lang.Integer index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public A addToSubnets(java.lang.Integer index,java.lang.String item) {
    if (this.subnets == null) {this.subnets = new java.util.ArrayList<java.lang.String>();}
    this.subnets.add(index, item);
    return (A)this;
  }
  public A setToSubnets(java.lang.Integer index,java.lang.String item) {
    if (this.subnets == null) {this.subnets = new java.util.ArrayList<java.lang.String>();}
    this.subnets.set(index, item); return (A)this;
  }
  public A addToSubnets(java.lang.String... items) {
    if (this.subnets == null) {this.subnets = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A addAllToSubnets(java.util.Collection<java.lang.String> items) {
    if (this.subnets == null) {this.subnets = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A removeFromSubnets(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public A removeAllFromSubnets(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getSubnets() {
    return this.subnets;
  }
  public java.lang.String getSubnet(java.lang.Integer index) {
    return this.subnets.get(index);
  }
  public java.lang.String getFirstSubnet() {
    return this.subnets.get(0);
  }
  public java.lang.String getLastSubnet() {
    return this.subnets.get(subnets.size() - 1);
  }
  public java.lang.String getMatchingSubnet(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: subnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingSubnet(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: subnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubnets(java.util.List<java.lang.String> subnets) {
    if (subnets != null) {this.subnets = new java.util.ArrayList(); for (java.lang.String item : subnets){this.addToSubnets(item);}} else { this.subnets = null;} return (A) this;
  }
  public A withSubnets(java.lang.String... subnets) {
    if (this.subnets != null) {this.subnets.clear();}
    if (subnets != null) {for (java.lang.String item :subnets){ this.addToSubnets(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubnets() {
    return subnets != null && !subnets.isEmpty();
  }
  public A addNewSubnet(java.lang.String arg0) {
    return (A)addToSubnets(new String(arg0));
  }
  public A addToUserTags(java.lang.String key,java.lang.String value) {
    if(this.userTags == null && key != null && value != null) { this.userTags = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.userTags.put(key, value);} return (A)this;
  }
  public A addToUserTags(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.userTags == null && map != null) { this.userTags = new java.util.LinkedHashMap(); }
    if(map != null) { this.userTags.putAll(map);} return (A)this;
  }
  public A removeFromUserTags(java.lang.String key) {
    if(this.userTags == null) { return (A) this; }
    if(key != null && this.userTags != null) {this.userTags.remove(key);} return (A)this;
  }
  public A removeFromUserTags(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.userTags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.userTags != null){this.userTags.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getUserTags() {
    return this.userTags;
  }
  public <K,V>A withUserTags(java.util.Map<java.lang.String,java.lang.String> userTags) {
    if (userTags == null) { this.userTags =  null;} else {this.userTags = new java.util.LinkedHashMap(userTags);} return (A) this;
  }
  public java.lang.Boolean hasUserTags() {
    return this.userTags != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (amiID != null ? !amiID.equals(that.amiID) :that.amiID != null) return false;
    if (defaultMachinePlatform != null ? !defaultMachinePlatform.equals(that.defaultMachinePlatform) :that.defaultMachinePlatform != null) return false;
    if (experimentalPropagateUserTags != null ? !experimentalPropagateUserTags.equals(that.experimentalPropagateUserTags) :that.experimentalPropagateUserTags != null) return false;
    if (hostedZone != null ? !hostedZone.equals(that.hostedZone) :that.hostedZone != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (serviceEndpoints != null ? !serviceEndpoints.equals(that.serviceEndpoints) :that.serviceEndpoints != null) return false;
    if (subnets != null ? !subnets.equals(that.subnets) :that.subnets != null) return false;
    if (userTags != null ? !userTags.equals(that.userTags) :that.userTags != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(amiID,  defaultMachinePlatform,  experimentalPropagateUserTags,  hostedZone,  region,  serviceEndpoints,  subnets,  userTags,  additionalProperties,  super.hashCode());
  }
  public class DefaultMachinePlatformNestedImpl<N> extends io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolFluentImpl<io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<N>> implements io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.DefaultMachinePlatformNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DefaultMachinePlatformNestedImpl(io.fabric8.openshift.api.model.installer.aws.v1.MachinePool item) {
      this.builder = new io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder(this);
    }
    io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  public class ServiceEndpointsNestedImpl<N> extends io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluentImpl<io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<N>> implements io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent.ServiceEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceEndpointsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(this, item);
    }
    ServiceEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder(this);
    }
    io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PlatformFluentImpl.this.setToServiceEndpoints(index,builder.build());
    }
    public N endServiceEndpoint() {
      return and();
    }
    
  }
  
}