package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HostBuilder extends io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluentImpl<io.fabric8.openshift.api.model.installer.baremetal.v1.HostBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.baremetal.v1.Host,io.fabric8.openshift.api.model.installer.baremetal.v1.HostBuilder>{
  public HostBuilder() {
    this(false);
  }
  public HostBuilder(java.lang.Boolean validationEnabled) {
    this(new Host(), validationEnabled);
  }
  public HostBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluent<?> fluent) {
    this(fluent, false);
  }
  public HostBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Host(), validationEnabled);
  }
  public HostBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluent<?> fluent,io.fabric8.openshift.api.model.installer.baremetal.v1.Host instance) {
    this(fluent, instance, false);
  }
  public HostBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluent<?> fluent,io.fabric8.openshift.api.model.installer.baremetal.v1.Host instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBmc(instance.getBmc()); 
    fluent.withBootMACAddress(instance.getBootMACAddress()); 
    fluent.withBootMode(instance.getBootMode()); 
    fluent.withHardwareProfile(instance.getHardwareProfile()); 
    fluent.withName(instance.getName()); 
    fluent.withNetworkConfig(instance.getNetworkConfig()); 
    fluent.withRole(instance.getRole()); 
    fluent.withRootDeviceHints(instance.getRootDeviceHints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.Host instance) {
    this(instance,false);
  }
  public HostBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.Host instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBmc(instance.getBmc()); 
    this.withBootMACAddress(instance.getBootMACAddress()); 
    this.withBootMode(instance.getBootMode()); 
    this.withHardwareProfile(instance.getHardwareProfile()); 
    this.withName(instance.getName()); 
    this.withNetworkConfig(instance.getNetworkConfig()); 
    this.withRole(instance.getRole()); 
    this.withRootDeviceHints(instance.getRootDeviceHints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.baremetal.v1.Host build() {
    Host buildable = new Host(fluent.getBmc(),fluent.getBootMACAddress(),fluent.getBootMode(),fluent.getHardwareProfile(),fluent.getName(),fluent.getNetworkConfig(),fluent.getRole(),fluent.getRootDeviceHints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HostBuilder that = (HostBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}