package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlatformBuilder extends io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluentImpl<io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.baremetal.v1.Platform,io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.baremetal.v1.Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.baremetal.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVIP(instance.getApiVIP()); 
    fluent.withBootstrapOSImage(instance.getBootstrapOSImage()); 
    fluent.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP()); 
    fluent.withClusterOSImage(instance.getClusterOSImage()); 
    fluent.withClusterProvisioningIP(instance.getClusterProvisioningIP()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withExternalBridge(instance.getExternalBridge()); 
    fluent.withExternalMACAddress(instance.getExternalMACAddress()); 
    fluent.withHosts(instance.getHosts()); 
    fluent.withIngressVIP(instance.getIngressVIP()); 
    fluent.withLibvirtURI(instance.getLibvirtURI()); 
    fluent.withProvisioningBridge(instance.getProvisioningBridge()); 
    fluent.withProvisioningDHCPExternal(instance.getProvisioningDHCPExternal()); 
    fluent.withProvisioningDHCPRange(instance.getProvisioningDHCPRange()); 
    fluent.withProvisioningHostIP(instance.getProvisioningHostIP()); 
    fluent.withProvisioningMACAddress(instance.getProvisioningMACAddress()); 
    fluent.withProvisioningNetwork(instance.getProvisioningNetwork()); 
    fluent.withProvisioningNetworkCIDR(instance.getProvisioningNetworkCIDR()); 
    fluent.withProvisioningNetworkInterface(instance.getProvisioningNetworkInterface()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.baremetal.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVIP(instance.getApiVIP()); 
    this.withBootstrapOSImage(instance.getBootstrapOSImage()); 
    this.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withClusterProvisioningIP(instance.getClusterProvisioningIP()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withExternalBridge(instance.getExternalBridge()); 
    this.withExternalMACAddress(instance.getExternalMACAddress()); 
    this.withHosts(instance.getHosts()); 
    this.withIngressVIP(instance.getIngressVIP()); 
    this.withLibvirtURI(instance.getLibvirtURI()); 
    this.withProvisioningBridge(instance.getProvisioningBridge()); 
    this.withProvisioningDHCPExternal(instance.getProvisioningDHCPExternal()); 
    this.withProvisioningDHCPRange(instance.getProvisioningDHCPRange()); 
    this.withProvisioningHostIP(instance.getProvisioningHostIP()); 
    this.withProvisioningMACAddress(instance.getProvisioningMACAddress()); 
    this.withProvisioningNetwork(instance.getProvisioningNetwork()); 
    this.withProvisioningNetworkCIDR(instance.getProvisioningNetworkCIDR()); 
    this.withProvisioningNetworkInterface(instance.getProvisioningNetworkInterface()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.baremetal.v1.Platform build() {
    Platform buildable = new Platform(fluent.getApiVIP(),fluent.getBootstrapOSImage(),fluent.getBootstrapProvisioningIP(),fluent.getClusterOSImage(),fluent.getClusterProvisioningIP(),fluent.getDefaultMachinePlatform(),fluent.getExternalBridge(),fluent.getExternalMACAddress(),fluent.getHosts(),fluent.getIngressVIP(),fluent.getLibvirtURI(),fluent.getProvisioningBridge(),fluent.getProvisioningDHCPExternal(),fluent.getProvisioningDHCPRange(),fluent.getProvisioningHostIP(),fluent.getProvisioningMACAddress(),fluent.getProvisioningNetwork(),fluent.getProvisioningNetworkCIDR(),fluent.getProvisioningNetworkInterface());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformBuilder that = (PlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}