package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class MachinePoolBuilder extends io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluentImpl<io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool,io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(false);
  }
  public MachinePoolBuilder(java.lang.Boolean validationEnabled) {
    this(new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluent<?> fluent,io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool instance) {
    this(fluent, instance, false);
  }
  public MachinePoolBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluent<?> fluent,io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAffinityGroupsNames(instance.getAffinityGroupsNames()); 
    fluent.withAutoPinningPolicy(instance.getAutoPinningPolicy()); 
    fluent.withCpu(instance.getCpu()); 
    fluent.withHugepages(instance.getHugepages()); 
    fluent.withInstanceTypeID(instance.getInstanceTypeID()); 
    fluent.withMemoryMB(instance.getMemoryMB()); 
    fluent.withOsDisk(instance.getOsDisk()); 
    fluent.withVmType(instance.getVmType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool instance) {
    this(instance,false);
  }
  public MachinePoolBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAffinityGroupsNames(instance.getAffinityGroupsNames()); 
    this.withAutoPinningPolicy(instance.getAutoPinningPolicy()); 
    this.withCpu(instance.getCpu()); 
    this.withHugepages(instance.getHugepages()); 
    this.withInstanceTypeID(instance.getInstanceTypeID()); 
    this.withMemoryMB(instance.getMemoryMB()); 
    this.withOsDisk(instance.getOsDisk()); 
    this.withVmType(instance.getVmType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getAffinityGroupsNames(),fluent.getAutoPinningPolicy(),fluent.getCpu(),fluent.getHugepages(),fluent.getInstanceTypeID(),fluent.getMemoryMB(),fluent.getOsDisk(),fluent.getVmType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolBuilder that = (MachinePoolBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}