/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryFluent;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryFluentImpl;
import java.util.Objects;

public class MachineNetworkEntryBuilder
extends MachineNetworkEntryFluentImpl<MachineNetworkEntryBuilder>
implements VisitableBuilder<MachineNetworkEntry, MachineNetworkEntryBuilder> {
    MachineNetworkEntryFluent<?> fluent;
    Boolean validationEnabled;

    public MachineNetworkEntryBuilder() {
        this(false);
    }

    public MachineNetworkEntryBuilder(Boolean validationEnabled) {
        this(new MachineNetworkEntry(), validationEnabled);
    }

    public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MachineNetworkEntry(), validationEnabled);
    }

    public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent, MachineNetworkEntry instance) {
        this(fluent, instance, false);
    }

    public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent, MachineNetworkEntry instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCidr(instance.getCidr());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public MachineNetworkEntryBuilder(MachineNetworkEntry instance) {
        this(instance, (Boolean)false);
    }

    public MachineNetworkEntryBuilder(MachineNetworkEntry instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCidr(instance.getCidr());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public MachineNetworkEntry build() {
        MachineNetworkEntry buildable = new MachineNetworkEntry(this.fluent.getCidr());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineNetworkEntryBuilder that = (MachineNetworkEntryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

