package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceEndpointBuilder extends io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluentImpl<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder>{
  public ServiceEndpointBuilder() {
    this(false);
  }
  public ServiceEndpointBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceEndpoint(), validationEnabled);
  }
  public ServiceEndpointBuilder(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEndpointBuilder(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceEndpoint(), validationEnabled);
  }
  public ServiceEndpointBuilder(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public ServiceEndpointBuilder(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceEndpointBuilder(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint instance) {
    this(instance,false);
  }
  public ServiceEndpointBuilder(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint build() {
    ServiceEndpoint buildable = new ServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceEndpointBuilder that = (ServiceEndpointBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}