package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlatformBuilder extends io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluentImpl<io.fabric8.openshift.api.model.installer.azure.v1.PlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.azure.v1.Platform,io.fabric8.openshift.api.model.installer.azure.v1.PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.azure.v1.Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.azure.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArmEndpoint(instance.getArmEndpoint()); 
    fluent.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName()); 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withClusterOSImage(instance.getClusterOSImage()); 
    fluent.withComputeSubnet(instance.getComputeSubnet()); 
    fluent.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    fluent.withOutboundType(instance.getOutboundType()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withResourceGroupName(instance.getResourceGroupName()); 
    fluent.withVirtualNetwork(instance.getVirtualNetwork()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.azure.v1.Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.azure.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withArmEndpoint(instance.getArmEndpoint()); 
    this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName()); 
    this.withCloudName(instance.getCloudName()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withComputeSubnet(instance.getComputeSubnet()); 
    this.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    this.withOutboundType(instance.getOutboundType()); 
    this.withRegion(instance.getRegion()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withVirtualNetwork(instance.getVirtualNetwork()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.azure.v1.Platform build() {
    Platform buildable = new Platform(fluent.getArmEndpoint(),fluent.getBaseDomainResourceGroupName(),fluent.getCloudName(),fluent.getClusterOSImage(),fluent.getComputeSubnet(),fluent.getControlPlaneSubnet(),fluent.getDefaultMachinePlatform(),fluent.getNetworkResourceGroupName(),fluent.getOutboundType(),fluent.getRegion(),fluent.getResourceGroupName(),fluent.getVirtualNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformBuilder that = (PlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}