package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlatformBuilder extends io.fabric8.openshift.api.model.installer.gcp.v1.PlatformFluentImpl<io.fabric8.openshift.api.model.installer.gcp.v1.PlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.gcp.v1.Platform,io.fabric8.openshift.api.model.installer.gcp.v1.PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.PlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.gcp.v1.Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.gcp.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withComputeSubnet(instance.getComputeSubnet()); 
    fluent.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withLicenses(instance.getLicenses()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withProjectID(instance.getProjectID()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.gcp.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withComputeSubnet(instance.getComputeSubnet()); 
    this.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withLicenses(instance.getLicenses()); 
    this.withNetwork(instance.getNetwork()); 
    this.withProjectID(instance.getProjectID()); 
    this.withRegion(instance.getRegion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.gcp.v1.PlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.gcp.v1.Platform build() {
    Platform buildable = new Platform(fluent.getComputeSubnet(),fluent.getControlPlaneSubnet(),fluent.getDefaultMachinePlatform(),fluent.getLicenses(),fluent.getNetwork(),fluent.getProjectID(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformBuilder that = (PlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}