package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkBuilder extends io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluentImpl<io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.libvirt.v1.Network,io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkBuilder>{
  public NetworkBuilder() {
    this(false);
  }
  public NetworkBuilder(java.lang.Boolean validationEnabled) {
    this(new Network(), validationEnabled);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Network(), validationEnabled);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent<?> fluent,io.fabric8.openshift.api.model.installer.libvirt.v1.Network instance) {
    this(fluent, instance, false);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent<?> fluent,io.fabric8.openshift.api.model.installer.libvirt.v1.Network instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDnsmasqOptions(instance.getDnsmasqOptions()); 
    fluent.withIf(instance.getIf()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.installer.libvirt.v1.Network instance) {
    this(instance,false);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.installer.libvirt.v1.Network instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDnsmasqOptions(instance.getDnsmasqOptions()); 
    this.withIf(instance.getIf()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.libvirt.v1.Network build() {
    Network buildable = new Network(fluent.getDnsmasqOptions(),fluent.getIf());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkBuilder that = (NetworkBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}