package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ProxyBuilder extends io.fabric8.openshift.api.model.installer.v1.ProxyFluentImpl<io.fabric8.openshift.api.model.installer.v1.ProxyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.v1.Proxy,io.fabric8.openshift.api.model.installer.v1.ProxyBuilder>{
  public ProxyBuilder() {
    this(false);
  }
  public ProxyBuilder(java.lang.Boolean validationEnabled) {
    this(new Proxy(), validationEnabled);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.installer.v1.ProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.installer.v1.ProxyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Proxy(), validationEnabled);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.installer.v1.ProxyFluent<?> fluent,io.fabric8.openshift.api.model.installer.v1.Proxy instance) {
    this(fluent, instance, false);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.installer.v1.ProxyFluent<?> fluent,io.fabric8.openshift.api.model.installer.v1.Proxy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.installer.v1.Proxy instance) {
    this(instance,false);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.installer.v1.Proxy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.v1.ProxyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.v1.Proxy build() {
    Proxy buildable = new Proxy(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxyBuilder that = (ProxyBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}