package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlatformBuilder extends io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluentImpl<io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.vsphere.v1.Platform,io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.vsphere.v1.Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.installer.vsphere.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVIP(instance.getApiVIP()); 
    fluent.withCluster(instance.getCluster()); 
    fluent.withClusterOSImage(instance.getClusterOSImage()); 
    fluent.withDatacenter(instance.getDatacenter()); 
    fluent.withDefaultDatastore(instance.getDefaultDatastore()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withDiskType(instance.getDiskType()); 
    fluent.withFolder(instance.getFolder()); 
    fluent.withIngressVIP(instance.getIngressVIP()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withPassword(instance.getPassword()); 
    fluent.withResourcePool(instance.getResourcePool()); 
    fluent.withUsername(instance.getUsername()); 
    fluent.withVCenter(instance.getVCenter()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.installer.vsphere.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVIP(instance.getApiVIP()); 
    this.withCluster(instance.getCluster()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withDatacenter(instance.getDatacenter()); 
    this.withDefaultDatastore(instance.getDefaultDatastore()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withDiskType(instance.getDiskType()); 
    this.withFolder(instance.getFolder()); 
    this.withIngressVIP(instance.getIngressVIP()); 
    this.withNetwork(instance.getNetwork()); 
    this.withPassword(instance.getPassword()); 
    this.withResourcePool(instance.getResourcePool()); 
    this.withUsername(instance.getUsername()); 
    this.withVCenter(instance.getVCenter()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.vsphere.v1.Platform build() {
    Platform buildable = new Platform(fluent.getApiVIP(),fluent.getCluster(),fluent.getClusterOSImage(),fluent.getDatacenter(),fluent.getDefaultDatastore(),fluent.getDefaultMachinePlatform(),fluent.getDiskType(),fluent.getFolder(),fluent.getIngressVIP(),fluent.getNetwork(),fluent.getPassword(),fluent.getResourcePool(),fluent.getUsername(),fluent.getVCenter());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformBuilder that = (PlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}