package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DiskBuilder extends io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluentImpl<io.fabric8.openshift.api.model.installer.ovirt.v1.DiskBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.ovirt.v1.Disk,io.fabric8.openshift.api.model.installer.ovirt.v1.DiskBuilder>{
  public DiskBuilder() {
    this(false);
  }
  public DiskBuilder(java.lang.Boolean validationEnabled) {
    this(new Disk(), validationEnabled);
  }
  public DiskBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent<?> fluent) {
    this(fluent, false);
  }
  public DiskBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Disk(), validationEnabled);
  }
  public DiskBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent<?> fluent,io.fabric8.openshift.api.model.installer.ovirt.v1.Disk instance) {
    this(fluent, instance, false);
  }
  public DiskBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent<?> fluent,io.fabric8.openshift.api.model.installer.ovirt.v1.Disk instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSizeGB(instance.getSizeGB()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DiskBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.Disk instance) {
    this(instance,false);
  }
  public DiskBuilder(io.fabric8.openshift.api.model.installer.ovirt.v1.Disk instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withSizeGB(instance.getSizeGB()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.ovirt.v1.Disk build() {
    Disk buildable = new Disk(fluent.getSizeGB());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DiskBuilder that = (DiskBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}