package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkingBuilder extends io.fabric8.openshift.api.model.installer.v1.NetworkingFluentImpl<io.fabric8.openshift.api.model.installer.v1.NetworkingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.installer.v1.Networking,io.fabric8.openshift.api.model.installer.v1.NetworkingBuilder>{
  public NetworkingBuilder() {
    this(false);
  }
  public NetworkingBuilder(java.lang.Boolean validationEnabled) {
    this(new Networking(), validationEnabled);
  }
  public NetworkingBuilder(io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkingBuilder(io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Networking(), validationEnabled);
  }
  public NetworkingBuilder(io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<?> fluent,io.fabric8.openshift.api.model.installer.v1.Networking instance) {
    this(fluent, instance, false);
  }
  public NetworkingBuilder(io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<?> fluent,io.fabric8.openshift.api.model.installer.v1.Networking instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterNetwork(instance.getClusterNetwork()); 
    fluent.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks()); 
    fluent.withMachineCIDR(instance.getMachineCIDR()); 
    fluent.withMachineNetwork(instance.getMachineNetwork()); 
    fluent.withNetworkType(instance.getNetworkType()); 
    fluent.withServiceCIDR(instance.getServiceCIDR()); 
    fluent.withServiceNetwork(instance.getServiceNetwork()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkingBuilder(io.fabric8.openshift.api.model.installer.v1.Networking instance) {
    this(instance,false);
  }
  public NetworkingBuilder(io.fabric8.openshift.api.model.installer.v1.Networking instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks()); 
    this.withMachineCIDR(instance.getMachineCIDR()); 
    this.withMachineNetwork(instance.getMachineNetwork()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceCIDR(instance.getServiceCIDR()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.installer.v1.NetworkingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.installer.v1.Networking build() {
    Networking buildable = new Networking(fluent.getClusterNetwork(),fluent.getDeprecatedClusterNetworks(),fluent.getMachineCIDR(),fluent.getMachineNetwork(),fluent.getNetworkType(),fluent.getServiceCIDR(),fluent.getServiceNetwork(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkingBuilder that = (NetworkingBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}