/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.azure.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.azure.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.azure.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.azure.v1.Platform;
import io.fabric8.openshift.api.model.installer.azure.v1.PlatformFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String armEndpoint;
    private String baseDomainResourceGroupName;
    private String cloudName;
    private String clusterOSImage;
    private String computeSubnet;
    private String controlPlaneSubnet;
    private MachinePoolBuilder defaultMachinePlatform;
    private String networkResourceGroupName;
    private String outboundType;
    private String region;
    private String resourceGroupName;
    private String virtualNetwork;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withArmEndpoint(instance.getArmEndpoint());
        this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName());
        this.withCloudName(instance.getCloudName());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withComputeSubnet(instance.getComputeSubnet());
        this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
        this.withOutboundType(instance.getOutboundType());
        this.withRegion(instance.getRegion());
        this.withResourceGroupName(instance.getResourceGroupName());
        this.withVirtualNetwork(instance.getVirtualNetwork());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getArmEndpoint() {
        return this.armEndpoint;
    }

    @Override
    public A withArmEndpoint(String armEndpoint) {
        this.armEndpoint = armEndpoint;
        return (A)this;
    }

    @Override
    public Boolean hasArmEndpoint() {
        return this.armEndpoint != null;
    }

    @Override
    public String getBaseDomainResourceGroupName() {
        return this.baseDomainResourceGroupName;
    }

    @Override
    public A withBaseDomainResourceGroupName(String baseDomainResourceGroupName) {
        this.baseDomainResourceGroupName = baseDomainResourceGroupName;
        return (A)this;
    }

    @Override
    public Boolean hasBaseDomainResourceGroupName() {
        return this.baseDomainResourceGroupName != null;
    }

    @Override
    public String getCloudName() {
        return this.cloudName;
    }

    @Override
    public A withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return (A)this;
    }

    @Override
    public Boolean hasCloudName() {
        return this.cloudName != null;
    }

    @Override
    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    @Override
    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    @Override
    public Boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    @Override
    public String getComputeSubnet() {
        return this.computeSubnet;
    }

    @Override
    public A withComputeSubnet(String computeSubnet) {
        this.computeSubnet = computeSubnet;
        return (A)this;
    }

    @Override
    public Boolean hasComputeSubnet() {
        return this.computeSubnet != null;
    }

    @Override
    public String getControlPlaneSubnet() {
        return this.controlPlaneSubnet;
    }

    @Override
    public A withControlPlaneSubnet(String controlPlaneSubnet) {
        this.controlPlaneSubnet = controlPlaneSubnet;
        return (A)this;
    }

    @Override
    public Boolean hasControlPlaneSubnet() {
        return this.controlPlaneSubnet != null;
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get((Object)"defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public String getNetworkResourceGroupName() {
        return this.networkResourceGroupName;
    }

    @Override
    public A withNetworkResourceGroupName(String networkResourceGroupName) {
        this.networkResourceGroupName = networkResourceGroupName;
        return (A)this;
    }

    @Override
    public Boolean hasNetworkResourceGroupName() {
        return this.networkResourceGroupName != null;
    }

    @Override
    public String getOutboundType() {
        return this.outboundType;
    }

    @Override
    public A withOutboundType(String outboundType) {
        this.outboundType = outboundType;
        return (A)this;
    }

    @Override
    public Boolean hasOutboundType() {
        return this.outboundType != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)this;
    }

    @Override
    public Boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    @Override
    public String getVirtualNetwork() {
        return this.virtualNetwork;
    }

    @Override
    public A withVirtualNetwork(String virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasVirtualNetwork() {
        return this.virtualNetwork != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.armEndpoint != null ? !this.armEndpoint.equals(that.armEndpoint) : that.armEndpoint != null) {
            return false;
        }
        if (this.baseDomainResourceGroupName != null ? !this.baseDomainResourceGroupName.equals(that.baseDomainResourceGroupName) : that.baseDomainResourceGroupName != null) {
            return false;
        }
        if (this.cloudName != null ? !this.cloudName.equals(that.cloudName) : that.cloudName != null) {
            return false;
        }
        if (this.clusterOSImage != null ? !this.clusterOSImage.equals(that.clusterOSImage) : that.clusterOSImage != null) {
            return false;
        }
        if (this.computeSubnet != null ? !this.computeSubnet.equals(that.computeSubnet) : that.computeSubnet != null) {
            return false;
        }
        if (this.controlPlaneSubnet != null ? !this.controlPlaneSubnet.equals(that.controlPlaneSubnet) : that.controlPlaneSubnet != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.networkResourceGroupName != null ? !this.networkResourceGroupName.equals(that.networkResourceGroupName) : that.networkResourceGroupName != null) {
            return false;
        }
        if (this.outboundType != null ? !this.outboundType.equals(that.outboundType) : that.outboundType != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.resourceGroupName != null ? !this.resourceGroupName.equals(that.resourceGroupName) : that.resourceGroupName != null) {
            return false;
        }
        if (this.virtualNetwork != null ? !this.virtualNetwork.equals(that.virtualNetwork) : that.virtualNetwork != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.armEndpoint, this.baseDomainResourceGroupName, this.cloudName, this.clusterOSImage, this.computeSubnet, this.controlPlaneSubnet, this.defaultMachinePlatform, this.networkResourceGroupName, this.outboundType, this.region, this.resourceGroupName, this.virtualNetwork, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.armEndpoint != null) {
            sb.append("armEndpoint:");
            sb.append(this.armEndpoint + ",");
        }
        if (this.baseDomainResourceGroupName != null) {
            sb.append("baseDomainResourceGroupName:");
            sb.append(this.baseDomainResourceGroupName + ",");
        }
        if (this.cloudName != null) {
            sb.append("cloudName:");
            sb.append(this.cloudName + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.computeSubnet != null) {
            sb.append("computeSubnet:");
            sb.append(this.computeSubnet + ",");
        }
        if (this.controlPlaneSubnet != null) {
            sb.append("controlPlaneSubnet:");
            sb.append(this.controlPlaneSubnet + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.networkResourceGroupName != null) {
            sb.append("networkResourceGroupName:");
            sb.append(this.networkResourceGroupName + ",");
        }
        if (this.outboundType != null) {
            sb.append("outboundType:");
            sb.append(this.outboundType + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroupName != null) {
            sb.append("resourceGroupName:");
            sb.append(this.resourceGroupName + ",");
        }
        if (this.virtualNetwork != null) {
            sb.append("virtualNetwork:");
            sb.append(this.virtualNetwork + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

