package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private List<String> additionalNetworkIDs = new ArrayList<String>();
  private List<String> additionalSecurityGroupIDs = new ArrayList<String>();
  private ArrayList<FailureDomainBuilder> failureDomains = new ArrayList<FailureDomainBuilder>();
  private RootVolumeBuilder rootVolume;
  private String serverGroupPolicy;
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
          this.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
          this.withFailureDomains(instance.getFailureDomains());
          this.withRootVolume(instance.getRootVolume());
          this.withServerGroupPolicy(instance.getServerGroupPolicy());
          this.withType(instance.getType());
          this.withZones(instance.getZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalNetworkIDs(int index,String item) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    this.additionalNetworkIDs.add(index, item);
    return (A)this;
  }
  
  public A setToAdditionalNetworkIDs(int index,String item) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    this.additionalNetworkIDs.set(index, item); return (A)this;
  }
  
  public A addToAdditionalNetworkIDs(java.lang.String... items) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalNetworkIDs.add(item);} return (A)this;
  }
  
  public A addAllToAdditionalNetworkIDs(Collection<String> items) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalNetworkIDs.add(item);} return (A)this;
  }
  
  public A removeFromAdditionalNetworkIDs(java.lang.String... items) {
    if (this.additionalNetworkIDs == null) return (A)this;
    for (String item : items) { this.additionalNetworkIDs.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdditionalNetworkIDs(Collection<String> items) {
    if (this.additionalNetworkIDs == null) return (A)this;
    for (String item : items) { this.additionalNetworkIDs.remove(item);} return (A)this;
  }
  
  public List<String> getAdditionalNetworkIDs() {
    return this.additionalNetworkIDs;
  }
  
  public String getAdditionalNetworkID(int index) {
    return this.additionalNetworkIDs.get(index);
  }
  
  public String getFirstAdditionalNetworkID() {
    return this.additionalNetworkIDs.get(0);
  }
  
  public String getLastAdditionalNetworkID() {
    return this.additionalNetworkIDs.get(additionalNetworkIDs.size() - 1);
  }
  
  public String getMatchingAdditionalNetworkID(Predicate<String> predicate) {
      for (String item : additionalNetworkIDs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalNetworkID(Predicate<String> predicate) {
      for (String item : additionalNetworkIDs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalNetworkIDs(List<String> additionalNetworkIDs) {
    if (additionalNetworkIDs != null) {
        this.additionalNetworkIDs = new ArrayList();
        for (String item : additionalNetworkIDs) {
          this.addToAdditionalNetworkIDs(item);
        }
    } else {
      this.additionalNetworkIDs = null;
    }
    return (A) this;
  }
  
  public A withAdditionalNetworkIDs(java.lang.String... additionalNetworkIDs) {
    if (this.additionalNetworkIDs != null) {
        this.additionalNetworkIDs.clear();
        _visitables.remove("additionalNetworkIDs");
    }
    if (additionalNetworkIDs != null) {
      for (String item : additionalNetworkIDs) {
        this.addToAdditionalNetworkIDs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalNetworkIDs() {
    return this.additionalNetworkIDs != null && !this.additionalNetworkIDs.isEmpty();
  }
  
  public A addToAdditionalSecurityGroupIDs(int index,String item) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    this.additionalSecurityGroupIDs.add(index, item);
    return (A)this;
  }
  
  public A setToAdditionalSecurityGroupIDs(int index,String item) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    this.additionalSecurityGroupIDs.set(index, item); return (A)this;
  }
  
  public A addToAdditionalSecurityGroupIDs(java.lang.String... items) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalSecurityGroupIDs.add(item);} return (A)this;
  }
  
  public A addAllToAdditionalSecurityGroupIDs(Collection<String> items) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalSecurityGroupIDs.add(item);} return (A)this;
  }
  
  public A removeFromAdditionalSecurityGroupIDs(java.lang.String... items) {
    if (this.additionalSecurityGroupIDs == null) return (A)this;
    for (String item : items) { this.additionalSecurityGroupIDs.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdditionalSecurityGroupIDs(Collection<String> items) {
    if (this.additionalSecurityGroupIDs == null) return (A)this;
    for (String item : items) { this.additionalSecurityGroupIDs.remove(item);} return (A)this;
  }
  
  public List<String> getAdditionalSecurityGroupIDs() {
    return this.additionalSecurityGroupIDs;
  }
  
  public String getAdditionalSecurityGroupID(int index) {
    return this.additionalSecurityGroupIDs.get(index);
  }
  
  public String getFirstAdditionalSecurityGroupID() {
    return this.additionalSecurityGroupIDs.get(0);
  }
  
  public String getLastAdditionalSecurityGroupID() {
    return this.additionalSecurityGroupIDs.get(additionalSecurityGroupIDs.size() - 1);
  }
  
  public String getMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
      for (String item : additionalSecurityGroupIDs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
      for (String item : additionalSecurityGroupIDs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalSecurityGroupIDs(List<String> additionalSecurityGroupIDs) {
    if (additionalSecurityGroupIDs != null) {
        this.additionalSecurityGroupIDs = new ArrayList();
        for (String item : additionalSecurityGroupIDs) {
          this.addToAdditionalSecurityGroupIDs(item);
        }
    } else {
      this.additionalSecurityGroupIDs = null;
    }
    return (A) this;
  }
  
  public A withAdditionalSecurityGroupIDs(java.lang.String... additionalSecurityGroupIDs) {
    if (this.additionalSecurityGroupIDs != null) {
        this.additionalSecurityGroupIDs.clear();
        _visitables.remove("additionalSecurityGroupIDs");
    }
    if (additionalSecurityGroupIDs != null) {
      for (String item : additionalSecurityGroupIDs) {
        this.addToAdditionalSecurityGroupIDs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalSecurityGroupIDs() {
    return this.additionalSecurityGroupIDs != null && !this.additionalSecurityGroupIDs.isEmpty();
  }
  
  public A addToFailureDomains(int index,FailureDomain item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    FailureDomainBuilder builder = new FailureDomainBuilder(item);
    if (index < 0 || index >= failureDomains.size()) { _visitables.get("failureDomains").add(builder); failureDomains.add(builder); } else { _visitables.get("failureDomains").add(index, builder); failureDomains.add(index, builder);}
    return (A)this;
  }
  
  public A setToFailureDomains(int index,FailureDomain item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    FailureDomainBuilder builder = new FailureDomainBuilder(item);
    if (index < 0 || index >= failureDomains.size()) { _visitables.get("failureDomains").add(builder); failureDomains.add(builder); } else { _visitables.get("failureDomains").set(index, builder); failureDomains.set(index, builder);}
    return (A)this;
  }
  
  public A addToFailureDomains(io.fabric8.openshift.api.model.installer.openstack.v1.FailureDomain... items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").add(builder);this.failureDomains.add(builder);} return (A)this;
  }
  
  public A addAllToFailureDomains(Collection<FailureDomain> items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").add(builder);this.failureDomains.add(builder);} return (A)this;
  }
  
  public A removeFromFailureDomains(io.fabric8.openshift.api.model.installer.openstack.v1.FailureDomain... items) {
    if (this.failureDomains == null) return (A)this;
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").remove(builder); this.failureDomains.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFailureDomains(Collection<FailureDomain> items) {
    if (this.failureDomains == null) return (A)this;
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").remove(builder); this.failureDomains.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFailureDomains(Predicate<FailureDomainBuilder> predicate) {
    if (failureDomains == null) return (A) this;
    final Iterator<FailureDomainBuilder> each = failureDomains.iterator();
    final List visitables = _visitables.get("failureDomains");
    while (each.hasNext()) {
      FailureDomainBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FailureDomain> buildFailureDomains() {
    return this.failureDomains != null ? build(failureDomains) : null;
  }
  
  public FailureDomain buildFailureDomain(int index) {
    return this.failureDomains.get(index).build();
  }
  
  public FailureDomain buildFirstFailureDomain() {
    return this.failureDomains.get(0).build();
  }
  
  public FailureDomain buildLastFailureDomain() {
    return this.failureDomains.get(failureDomains.size() - 1).build();
  }
  
  public FailureDomain buildMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
      for (FailureDomainBuilder item : failureDomains) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
      for (FailureDomainBuilder item : failureDomains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFailureDomains(List<FailureDomain> failureDomains) {
    if (this.failureDomains != null) {
      this._visitables.get("failureDomains").clear();
    }
    if (failureDomains != null) {
        this.failureDomains = new ArrayList();
        for (FailureDomain item : failureDomains) {
          this.addToFailureDomains(item);
        }
    } else {
      this.failureDomains = null;
    }
    return (A) this;
  }
  
  public A withFailureDomains(io.fabric8.openshift.api.model.installer.openstack.v1.FailureDomain... failureDomains) {
    if (this.failureDomains != null) {
        this.failureDomains.clear();
        _visitables.remove("failureDomains");
    }
    if (failureDomains != null) {
      for (FailureDomain item : failureDomains) {
        this.addToFailureDomains(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFailureDomains() {
    return this.failureDomains != null && !this.failureDomains.isEmpty();
  }
  
  public FailureDomainsNested<A> addNewFailureDomain() {
    return new FailureDomainsNested(-1, null);
  }
  
  public FailureDomainsNested<A> addNewFailureDomainLike(FailureDomain item) {
    return new FailureDomainsNested(-1, item);
  }
  
  public FailureDomainsNested<A> setNewFailureDomainLike(int index,FailureDomain item) {
    return new FailureDomainsNested(index, item);
  }
  
  public FailureDomainsNested<A> editFailureDomain(int index) {
    if (failureDomains.size() <= index) throw new RuntimeException("Can't edit failureDomains. Index exceeds size.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public FailureDomainsNested<A> editFirstFailureDomain() {
    if (failureDomains.size() == 0) throw new RuntimeException("Can't edit first failureDomains. The list is empty.");
    return setNewFailureDomainLike(0, buildFailureDomain(0));
  }
  
  public FailureDomainsNested<A> editLastFailureDomain() {
    int index = failureDomains.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last failureDomains. The list is empty.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public FailureDomainsNested<A> editMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
    int index = -1;
    for (int i=0;i<failureDomains.size();i++) { 
    if (predicate.test(failureDomains.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching failureDomains. No match found.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public RootVolume buildRootVolume() {
    return this.rootVolume != null ? this.rootVolume.build() : null;
  }
  
  public A withRootVolume(RootVolume rootVolume) {
    this._visitables.remove("rootVolume");
    if (rootVolume != null) {
        this.rootVolume = new RootVolumeBuilder(rootVolume);
        this._visitables.get("rootVolume").add(this.rootVolume);
    } else {
        this.rootVolume = null;
        this._visitables.get("rootVolume").remove(this.rootVolume);
    }
    return (A) this;
  }
  
  public boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  
  public RootVolumeNested<A> withNewRootVolume() {
    return new RootVolumeNested(null);
  }
  
  public RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
    return new RootVolumeNested(item);
  }
  
  public RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(null));
  }
  
  public RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(new RootVolumeBuilder().build()));
  }
  
  public RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(item));
  }
  
  public String getServerGroupPolicy() {
    return this.serverGroupPolicy;
  }
  
  public A withServerGroupPolicy(String serverGroupPolicy) {
    this.serverGroupPolicy = serverGroupPolicy;
    return (A) this;
  }
  
  public boolean hasServerGroupPolicy() {
    return this.serverGroupPolicy != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public List<String> getZones() {
    return this.zones;
  }
  
  public String getZone(int index) {
    return this.zones.get(index);
  }
  
  public String getFirstZone() {
    return this.zones.get(0);
  }
  
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  
  public String getMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withZones(List<String> zones) {
    if (zones != null) {
        this.zones = new ArrayList();
        for (String item : zones) {
          this.addToZones(item);
        }
    } else {
      this.zones = null;
    }
    return (A) this;
  }
  
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {
        this.zones.clear();
        _visitables.remove("zones");
    }
    if (zones != null) {
      for (String item : zones) {
        this.addToZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasZones() {
    return this.zones != null && !this.zones.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(additionalNetworkIDs, that.additionalNetworkIDs)) return false;
    if (!java.util.Objects.equals(additionalSecurityGroupIDs, that.additionalSecurityGroupIDs)) return false;
    if (!java.util.Objects.equals(failureDomains, that.failureDomains)) return false;
    if (!java.util.Objects.equals(rootVolume, that.rootVolume)) return false;
    if (!java.util.Objects.equals(serverGroupPolicy, that.serverGroupPolicy)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(zones, that.zones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalNetworkIDs,  additionalSecurityGroupIDs,  failureDomains,  rootVolume,  serverGroupPolicy,  type,  zones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalNetworkIDs != null && !additionalNetworkIDs.isEmpty()) { sb.append("additionalNetworkIDs:"); sb.append(additionalNetworkIDs + ","); }
    if (additionalSecurityGroupIDs != null && !additionalSecurityGroupIDs.isEmpty()) { sb.append("additionalSecurityGroupIDs:"); sb.append(additionalSecurityGroupIDs + ","); }
    if (failureDomains != null && !failureDomains.isEmpty()) { sb.append("failureDomains:"); sb.append(failureDomains + ","); }
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (serverGroupPolicy != null) { sb.append("serverGroupPolicy:"); sb.append(serverGroupPolicy + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FailureDomainsNested<N> extends FailureDomainFluent<FailureDomainsNested<N>> implements Nested<N>{
    FailureDomainsNested(int index,FailureDomain item) {
      this.index = index;
      this.builder = new FailureDomainBuilder(this, item);
    }
    FailureDomainBuilder builder;
    int index;
    
    public N and() {
      return (N) MachinePoolFluent.this.setToFailureDomains(index,builder.build());
    }
    
    public N endFailureDomain() {
      return and();
    }
    
  
  }
  public class RootVolumeNested<N> extends RootVolumeFluent<RootVolumeNested<N>> implements Nested<N>{
    RootVolumeNested(RootVolume item) {
      this.builder = new RootVolumeBuilder(this, item);
    }
    RootVolumeBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withRootVolume(builder.build());
    }
    
    public N endRootVolume() {
      return and();
    }
    
  
  }

}