package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PrismCentralBuilder extends PrismCentralFluent<PrismCentralBuilder> implements VisitableBuilder<PrismCentral,PrismCentralBuilder>{
  public PrismCentralBuilder() {
    this(new PrismCentral());
  }
  
  public PrismCentralBuilder(PrismCentralFluent<?> fluent) {
    this(fluent, new PrismCentral());
  }
  
  public PrismCentralBuilder(PrismCentralFluent<?> fluent,PrismCentral instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PrismCentralBuilder(PrismCentral instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PrismCentralFluent<?> fluent;
  
  public PrismCentral build() {
    PrismCentral buildable = new PrismCentral(fluent.buildEndpoint(),fluent.getPassword(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}