package io.fabric8.openshift.api.model.installer.alibabacloud.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withPrivateZoneID(instance.getPrivateZoneID()); 
    this.withRegion(instance.getRegion()); 
    this.withResourceGroupID(instance.getResourceGroupID()); 
    this.withTags(instance.getTags()); 
    this.withVpcID(instance.getVpcID()); 
    this.withVswitchIDs(instance.getVswitchIDs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private MachinePoolBuilder defaultMachinePlatform;
  private String privateZoneID;
  private String region;
  private String resourceGroupID;
  private Map<String,String> tags;
  private String vpcID;
  private List<String> vswitchIDs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public String getPrivateZoneID() {
    return this.privateZoneID;
  }
  public A withPrivateZoneID(String privateZoneID) {
    this.privateZoneID=privateZoneID; return (A) this;
  }
  public Boolean hasPrivateZoneID() {
    return this.privateZoneID != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getResourceGroupID() {
    return this.resourceGroupID;
  }
  public A withResourceGroupID(String resourceGroupID) {
    this.resourceGroupID=resourceGroupID; return (A) this;
  }
  public Boolean hasResourceGroupID() {
    return this.resourceGroupID != null;
  }
  public A addToTags(String key,String value) {
    if(this.tags == null && key != null && value != null) { this.tags = new LinkedHashMap(); }
    if(key != null && value != null) {this.tags.put(key, value);} return (A)this;
  }
  public A addToTags(Map<String,String> map) {
    if(this.tags == null && map != null) { this.tags = new LinkedHashMap(); }
    if(map != null) { this.tags.putAll(map);} return (A)this;
  }
  public A removeFromTags(String key) {
    if(this.tags == null) { return (A) this; }
    if(key != null && this.tags != null) {this.tags.remove(key);} return (A)this;
  }
  public A removeFromTags(Map<String,String> map) {
    if(this.tags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.tags != null){this.tags.remove(key);}}} return (A)this;
  }
  public Map<String,String> getTags() {
    return this.tags;
  }
  public <K,V>A withTags(Map<String,String> tags) {
    if (tags == null) { this.tags =  null;} else {this.tags = new LinkedHashMap(tags);} return (A) this;
  }
  public Boolean hasTags() {
    return this.tags != null;
  }
  public String getVpcID() {
    return this.vpcID;
  }
  public A withVpcID(String vpcID) {
    this.vpcID=vpcID; return (A) this;
  }
  public Boolean hasVpcID() {
    return this.vpcID != null;
  }
  public A addToVswitchIDs(Integer index,String item) {
    if (this.vswitchIDs == null) {this.vswitchIDs = new ArrayList<String>();}
    this.vswitchIDs.add(index, item);
    return (A)this;
  }
  public A setToVswitchIDs(Integer index,String item) {
    if (this.vswitchIDs == null) {this.vswitchIDs = new ArrayList<String>();}
    this.vswitchIDs.set(index, item); return (A)this;
  }
  public A addToVswitchIDs(java.lang.String... items) {
    if (this.vswitchIDs == null) {this.vswitchIDs = new ArrayList<String>();}
    for (String item : items) {this.vswitchIDs.add(item);} return (A)this;
  }
  public A addAllToVswitchIDs(Collection<String> items) {
    if (this.vswitchIDs == null) {this.vswitchIDs = new ArrayList<String>();}
    for (String item : items) {this.vswitchIDs.add(item);} return (A)this;
  }
  public A removeFromVswitchIDs(java.lang.String... items) {
    for (String item : items) {if (this.vswitchIDs!= null){ this.vswitchIDs.remove(item);}} return (A)this;
  }
  public A removeAllFromVswitchIDs(Collection<String> items) {
    for (String item : items) {if (this.vswitchIDs!= null){ this.vswitchIDs.remove(item);}} return (A)this;
  }
  public List<String> getVswitchIDs() {
    return this.vswitchIDs;
  }
  public String getVswitchID(Integer index) {
    return this.vswitchIDs.get(index);
  }
  public String getFirstVswitchID() {
    return this.vswitchIDs.get(0);
  }
  public String getLastVswitchID() {
    return this.vswitchIDs.get(vswitchIDs.size() - 1);
  }
  public String getMatchingVswitchID(Predicate<String> predicate) {
    for (String item: vswitchIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVswitchID(Predicate<String> predicate) {
    for (String item: vswitchIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVswitchIDs(List<String> vswitchIDs) {
    if (vswitchIDs != null) {this.vswitchIDs = new ArrayList(); for (String item : vswitchIDs){this.addToVswitchIDs(item);}} else { this.vswitchIDs = null;} return (A) this;
  }
  public A withVswitchIDs(java.lang.String... vswitchIDs) {
    if (this.vswitchIDs != null) {this.vswitchIDs.clear();}
    if (vswitchIDs != null) {for (String item :vswitchIDs){ this.addToVswitchIDs(item);}} return (A) this;
  }
  public Boolean hasVswitchIDs() {
    return vswitchIDs != null && !vswitchIDs.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (defaultMachinePlatform != null ? !defaultMachinePlatform.equals(that.defaultMachinePlatform) :that.defaultMachinePlatform != null) return false;
    if (privateZoneID != null ? !privateZoneID.equals(that.privateZoneID) :that.privateZoneID != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (resourceGroupID != null ? !resourceGroupID.equals(that.resourceGroupID) :that.resourceGroupID != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (vpcID != null ? !vpcID.equals(that.vpcID) :that.vpcID != null) return false;
    if (vswitchIDs != null ? !vswitchIDs.equals(that.vswitchIDs) :that.vswitchIDs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(defaultMachinePlatform,  privateZoneID,  region,  resourceGroupID,  tags,  vpcID,  vswitchIDs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (privateZoneID != null) { sb.append("privateZoneID:"); sb.append(privateZoneID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceGroupID != null) { sb.append("resourceGroupID:"); sb.append(resourceGroupID + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (vpcID != null) { sb.append("vpcID:"); sb.append(vpcID + ","); }
    if (vswitchIDs != null && !vswitchIDs.isEmpty()) { sb.append("vswitchIDs:"); sb.append(vswitchIDs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>> implements PlatformFluent.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}