package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OSDiskFluentImpl<A extends OSDiskFluent<A>> extends BaseFluent<A> implements OSDiskFluent<A>{
  public OSDiskFluentImpl() {
  }
  public OSDiskFluentImpl(OSDisk instance) {
    this.withDiskSizeGB(instance.getDiskSizeGB()); 
    this.withDiskType(instance.getDiskType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer diskSizeGB;
  private String diskType;
  private Map<String,Object> additionalProperties;
  public Integer getDiskSizeGB() {
    return this.diskSizeGB;
  }
  public A withDiskSizeGB(Integer diskSizeGB) {
    this.diskSizeGB=diskSizeGB; return (A) this;
  }
  public Boolean hasDiskSizeGB() {
    return this.diskSizeGB != null;
  }
  public String getDiskType() {
    return this.diskType;
  }
  public A withDiskType(String diskType) {
    this.diskType=diskType; return (A) this;
  }
  public Boolean hasDiskType() {
    return this.diskType != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OSDiskFluentImpl that = (OSDiskFluentImpl) o;
    if (diskSizeGB != null ? !diskSizeGB.equals(that.diskSizeGB) :that.diskSizeGB != null) return false;
    if (diskType != null ? !diskType.equals(that.diskType) :that.diskType != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(diskSizeGB,  diskType,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (diskSizeGB != null) { sb.append("diskSizeGB:"); sb.append(diskSizeGB + ","); }
    if (diskType != null) { sb.append("diskType:"); sb.append(diskType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}