package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withComputeSubnet(instance.getComputeSubnet()); 
    fluent.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withLicenses(instance.getLicenses()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withProjectID(instance.getProjectID()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withComputeSubnet(instance.getComputeSubnet()); 
    this.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withLicenses(instance.getLicenses()); 
    this.withNetwork(instance.getNetwork()); 
    this.withProjectID(instance.getProjectID()); 
    this.withRegion(instance.getRegion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getComputeSubnet(),fluent.getControlPlaneSubnet(),fluent.getDefaultMachinePlatform(),fluent.getLicenses(),fluent.getNetwork(),fluent.getProjectID(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}