package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkFluentImpl<A extends NetworkFluent<A>> extends BaseFluent<A> implements NetworkFluent<A>{
  public NetworkFluentImpl() {
  }
  public NetworkFluentImpl(Network instance) {
    this.withDnsmasqOptions(instance.getDnsmasqOptions()); 
    this.withIf(instance.getIf()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<DnsmasqOptionBuilder> dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
  private String _if;
  private Map<String,Object> additionalProperties;
  public A addToDnsmasqOptions(Integer index,DnsmasqOption item) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").add(index >= 0 ? index : _visitables.get("dnsmasqOptions").size(), builder);this.dnsmasqOptions.add(index >= 0 ? index : dnsmasqOptions.size(), builder); return (A)this;
  }
  public A setToDnsmasqOptions(Integer index,DnsmasqOption item) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
    if (index < 0 || index >= _visitables.get("dnsmasqOptions").size()) { _visitables.get("dnsmasqOptions").add(builder); } else { _visitables.get("dnsmasqOptions").set(index, builder);}
    if (index < 0 || index >= dnsmasqOptions.size()) { dnsmasqOptions.add(builder); } else { dnsmasqOptions.set(index, builder);}
     return (A)this;
  }
  public A addToDnsmasqOptions(io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption... items) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").add(builder);this.dnsmasqOptions.add(builder);} return (A)this;
  }
  public A addAllToDnsmasqOptions(Collection<DnsmasqOption> items) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").add(builder);this.dnsmasqOptions.add(builder);} return (A)this;
  }
  public A removeFromDnsmasqOptions(io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption... items) {
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").remove(builder);if (this.dnsmasqOptions != null) {this.dnsmasqOptions.remove(builder);}} return (A)this;
  }
  public A removeAllFromDnsmasqOptions(Collection<DnsmasqOption> items) {
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").remove(builder);if (this.dnsmasqOptions != null) {this.dnsmasqOptions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDnsmasqOptions(Predicate<DnsmasqOptionBuilder> predicate) {
    if (dnsmasqOptions == null) return (A) this;
    final Iterator<DnsmasqOptionBuilder> each = dnsmasqOptions.iterator();
    final List visitables = _visitables.get("dnsmasqOptions");
    while (each.hasNext()) {
      DnsmasqOptionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDnsmasqOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DnsmasqOption> getDnsmasqOptions() {
    return dnsmasqOptions != null ? build(dnsmasqOptions) : null;
  }
  public List<DnsmasqOption> buildDnsmasqOptions() {
    return dnsmasqOptions != null ? build(dnsmasqOptions) : null;
  }
  public DnsmasqOption buildDnsmasqOption(Integer index) {
    return this.dnsmasqOptions.get(index).build();
  }
  public DnsmasqOption buildFirstDnsmasqOption() {
    return this.dnsmasqOptions.get(0).build();
  }
  public DnsmasqOption buildLastDnsmasqOption() {
    return this.dnsmasqOptions.get(dnsmasqOptions.size() - 1).build();
  }
  public DnsmasqOption buildMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
    for (DnsmasqOptionBuilder item: dnsmasqOptions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
    for (DnsmasqOptionBuilder item: dnsmasqOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsmasqOptions(List<DnsmasqOption> dnsmasqOptions) {
    if (this.dnsmasqOptions != null) { _visitables.get("dnsmasqOptions").removeAll(this.dnsmasqOptions);}
    if (dnsmasqOptions != null) {this.dnsmasqOptions = new ArrayList(); for (DnsmasqOption item : dnsmasqOptions){this.addToDnsmasqOptions(item);}} else { this.dnsmasqOptions = null;} return (A) this;
  }
  public A withDnsmasqOptions(io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption... dnsmasqOptions) {
    if (this.dnsmasqOptions != null) {this.dnsmasqOptions.clear();}
    if (dnsmasqOptions != null) {for (DnsmasqOption item :dnsmasqOptions){ this.addToDnsmasqOptions(item);}} return (A) this;
  }
  public Boolean hasDnsmasqOptions() {
    return dnsmasqOptions != null && !dnsmasqOptions.isEmpty();
  }
  public A addNewDnsmasqOption(String name,String value) {
    return (A)addToDnsmasqOptions(new DnsmasqOption(name, value));
  }
  public NetworkFluent.DnsmasqOptionsNested<A> addNewDnsmasqOption() {
    return new NetworkFluentImpl.DnsmasqOptionsNestedImpl();
  }
  public NetworkFluent.DnsmasqOptionsNested<A> addNewDnsmasqOptionLike(DnsmasqOption item) {
    return new NetworkFluentImpl.DnsmasqOptionsNestedImpl(-1, item);
  }
  public NetworkFluent.DnsmasqOptionsNested<A> setNewDnsmasqOptionLike(Integer index,DnsmasqOption item) {
    return new NetworkFluentImpl.DnsmasqOptionsNestedImpl(index, item);
  }
  public NetworkFluent.DnsmasqOptionsNested<A> editDnsmasqOption(Integer index) {
    if (dnsmasqOptions.size() <= index) throw new RuntimeException("Can't edit dnsmasqOptions. Index exceeds size.");
    return setNewDnsmasqOptionLike(index, buildDnsmasqOption(index));
  }
  public NetworkFluent.DnsmasqOptionsNested<A> editFirstDnsmasqOption() {
    if (dnsmasqOptions.size() == 0) throw new RuntimeException("Can't edit first dnsmasqOptions. The list is empty.");
    return setNewDnsmasqOptionLike(0, buildDnsmasqOption(0));
  }
  public NetworkFluent.DnsmasqOptionsNested<A> editLastDnsmasqOption() {
    int index = dnsmasqOptions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dnsmasqOptions. The list is empty.");
    return setNewDnsmasqOptionLike(index, buildDnsmasqOption(index));
  }
  public NetworkFluent.DnsmasqOptionsNested<A> editMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dnsmasqOptions.size();i++) { 
    if (predicate.test(dnsmasqOptions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dnsmasqOptions. No match found.");
    return setNewDnsmasqOptionLike(index, buildDnsmasqOption(index));
  }
  public String getIf() {
    return this._if;
  }
  public A withIf(String _if) {
    this._if=_if; return (A) this;
  }
  public Boolean hasIf() {
    return this._if != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkFluentImpl that = (NetworkFluentImpl) o;
    if (dnsmasqOptions != null ? !dnsmasqOptions.equals(that.dnsmasqOptions) :that.dnsmasqOptions != null) return false;
    if (_if != null ? !_if.equals(that._if) :that._if != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dnsmasqOptions,  _if,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsmasqOptions != null && !dnsmasqOptions.isEmpty()) { sb.append("dnsmasqOptions:"); sb.append(dnsmasqOptions + ","); }
    if (_if != null) { sb.append("_if:"); sb.append(_if + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DnsmasqOptionsNestedImpl<N> extends DnsmasqOptionFluentImpl<NetworkFluent.DnsmasqOptionsNested<N>> implements NetworkFluent.DnsmasqOptionsNested<N>,Nested<N>{
    DnsmasqOptionsNestedImpl(Integer index,DnsmasqOption item) {
      this.index = index;
      this.builder = new DnsmasqOptionBuilder(this, item);
    }
    DnsmasqOptionsNestedImpl() {
      this.index = -1;
      this.builder = new DnsmasqOptionBuilder(this);
    }
    DnsmasqOptionBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkFluentImpl.this.setToDnsmasqOptions(index,builder.build());
    }
    public N endDnsmasqOption() {
      return and();
    }
    
  }
  
}